% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{filter_cells}
\alias{filter_cells}
\title{Filter cells with quality control criteria}
\usage{
filter_cells(object, umi.min = 0, umi.max = Inf, plot = TRUE,
  remove.zeros = TRUE)
}
\arguments{
\item{object}{\code{scNMFSet} object}

\item{umi.min}{Minimum UMI count for cell filtering}

\item{umi.max}{Maximum UMI count for cell filtering}

\item{plot}{If \code{TRUE}, the UMI count distribution of all cells 
will be displayed. Cells selected are colored red.}

\item{remove.zeros}{Remove rows/columns containing zeros only}
}
\value{
\code{scNMFSet} object with cells filtered.
}
\description{
Remove low quality cell entries from object
}
\details{
Takes as input \code{scNMFSet} object and plots histogram of UMI 
counts for each 
cell. Optionally, cells are filtered using minimum and maximum UMI counts. 
The resulting object is returned after removing empty rows and columns, 
if any.
}
\examples{
set.seed(1)
s <- scNMFSet(matrix(stats::rpois(n=1200,lambda=3),40,30))
s <- filter_cells(s,umi.min=10^2.0,umi.max=10^2.1)
}
