% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cluster_id}
\alias{cluster_id}
\title{Assign cells into clusters}
\usage{
cluster_id(object, rank = 2)
}
\arguments{
\item{object}{Object of class \code{scNMFSet}}

\item{rank}{Rank value whose factor matrices are to be used for 
assignment.}
}
\value{
Vector of length equal to the number of cells containing 
     cluster ID numbers of each cell.
}
\description{
Use factorization results in an object to assign cells into clusters.
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50,ncol=100,rank=5)
s <- scNMFSet(count=x$x)
s <- vb_factorize(s,ranks=seq(2,8),nrun=5)
cid <- cluster_id(s, rank=5)
table(cid)
}
