% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{generateOncotreeUIwidgets}
\alias{generateOncotreeUIwidgets}
\title{Create shiny UI-widget for specific columns of oncotree entries}
\usage{
generateOncotreeUIwidgets(
  colname,
  mode = c("add", "edit"),
  tab = c("Patient", "Sample")
)
}
\arguments{
\item{colname}{column name}

\item{mode}{determines the inputId prefix of the UI-widget}

\item{tab}{"Patient", "Sample" - The used tab; sets the html id prefix of the input}
}
\value{
A oncotree specific shiny UI-widget
}
\description{
Create shiny UI-widget for specific columns of oncotree entries
}
\examples{
oncotree <- jsonlite::fromJSON(system.file("extdata", "oncotree.json", package = "cbpManager"))
cancer_type <- unique(oncotree$mainType[which(!is.na(oncotree$mainType))])
cbpManager:::generateOncotreeUIwidgets("CANCER_TYPE", "add")

}
