% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbaf-availableData.R
\name{availableData}
\alias{availableData}
\title{Check which Data types are available for each cancer study.}
\usage{
availableData(excelFileName, oneOfEach = FALSE)
}
\arguments{
\item{excelFileName}{a character string that is required to name the output
and, if requested, excel file.}

\item{oneOfEach}{a character string that is used to alter the function's
behavior to select unique one cancer of each type that contains data for the
requested technique. The default value is \code{"FALSE"}. Supported
techniques include \code{"RNA-Seq"}, \code{"RNA-SeqRTN"},
\code{"microRNA-Seq"}, \code{"Microarray.mRNA"}, \code{"Microarray.mRNA"},
and \code{"methylation"}.}
}
\value{
An excel file that contains all the cancer studies versus available
data types
}
\description{
This function checks all the cancer studies that are registered
in 'cbioportal.org' to examine whether or not they contain RNA-Seq,
microRNA-Seq, microarray(mRNA), microarray(miRNA) and methylation data.
}
\details{
\tabular{lllll}{
Package: \tab cbaf \cr
Type: \tab Package \cr
Version: \tab 1.31.1 \cr
Date: \tab 2025-10-26 \cr
License: \tab Artistic-2.0 \cr
}
}
\author{
Arman Shahrisa, \email{shahrisa.arman@hotmail.com} [maintainer,
copyright holder]

Maryam Tahmasebi Birgani, \email{tahmasebi-ma@ajums.ac.ir}
}
