\name{cytOutData-methods}
\docType{methods}
\alias{cytOutData}
\alias{cytOutData-methods}
\alias{cytOutData,list,ccCompareResult,mergedData-method}
\alias{cytOutData,list,ccCompareResult,missing-method}
\alias{cytOutData,list,missing,missing-method}
\title{  Methods for Function \code{cytOutData}  }
\description{
Takes the \code{saveObj} generated by \code{cytOutNodes} and writes the data to a file
}
\section{Methods}{
\describe{

\item{\code{signature(saveObj = "list", compareResult = "ccCompareResult", mergedData = "mergedData")}}{
\code{saveObj} is the list object generated by \code{cytOutNodes}, \code{compareResult} is the object from \code{ccCompare}, and \code{mergedData} is created using \code{mergeLists}, but is optional.
}
\item{\code{...}}{: optional arguments also include: \code{orgType}, default is "header" where each group is seperate, "annotate" pushes all the data into one table with a new column that designates which groups the annotation was found in; \code{fileName}, the name of a text file to output the results to; \code{displayFile}, whether or not to display the file (default is "FALSE")}
}
}
\value{
A text file with the annotations previously saved using \code{cytOutNodes}
}
\examples{
\dontrun{
hasCy <- (if (.Platform$OS.type \%in\% "windows") {
(length(grep("Cytoscape", system("tasklist", intern=TRUE))) > 0)})

if hasCy {
	data(ccData)
	ccResults$BP <- breakEdges(ccResults$BP, 0.8)
	cwObj <- ccOutCyt(ccResults$BP,ccOpts)
	# user selects some nodes in Cytoscape
	RCy3::selectNodes(cwObj, c("GO:0007017", "GO:0000226", "GO:0007051", "GO:0007052"))
	savedNodes <- cytOutNodes("random1", cwObj) # save them
	# and selects some other nodes
	RCy3::selectNodes(cwObj,
	c("GO:0071103", "GO:0034728", "GO:0006323", "GO:0030261", "GO:0006334"),
	preserve.current.selection=FALSE)
	savedNodes <- cytOutNodes("random2", cwObj, savedNodes)

	# now spit results out to a file
	cytOutData(savedNodes, ccResults$BP)
}}}
\keyword{methods}
