% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_snp_circos}
\alias{plot_snp_circos}
\title{Circos plot of SNP distribution across chromosomes}
\usage{
plot_snp_circos(genome_ranges, gene_ranges, marker_ranges)
}
\arguments{
\item{genome_ranges}{A GRanges object with chromosome lengths.}

\item{gene_ranges}{A GRanges object with genomic coordinates
of all genes in the genome.}

\item{marker_ranges}{Genomic positions of SNPs. For a single trait,
a GRanges object. For multiple traits, a GRangesList or CompressedGRangesList
object, with each element of the list representing SNP positions for a
particular trait.}
}
\value{
A ggplot object with a circos plot of molecular marker distribution
across chromosomes.
}
\description{
Circos plot of SNP distribution across chromosomes
}
\examples{
data(snp_pos)
data(gene_ranges)
data(chr_length)
p <- plot_snp_circos(chr_length, gene_ranges, snp_pos)
}
