% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{prepareGSEAgenesets}
\alias{prepareGSEAgenesets}
\title{Prepare GSEA gene sets}
\usage{
prepareGSEAgenesets(input, geneSize)
}
\arguments{
\item{input}{\code{Named numeric vector} of differentially expressed genes
whose names are gene identifiers and respective values are a statistic that
represents significance and magnitude of differentially expressed genes
(e.g. t-statistics); or \code{character} of gene symbols composing a gene
set that is tested for enrichment in reference data (only used if
\code{method} includes \code{gsea})}

\item{geneSize}{Numeric: number of top up-/down-regulated genes to use as
gene sets to test for enrichment in reference data; if a 2-length numeric
vector, the first index is the number of top up-regulated genes and the
second index is the number of down-regulated genes used to create gene
sets; only used if \code{method} includes \code{gsea} and if \code{input}
is not a gene set}
}
\value{
List of gene sets
}
\description{
Prepare GSEA gene sets
}
\keyword{internal}
