% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{getCMapConditions}
\alias{getCMapConditions}
\title{List available conditions in CMap datasets}
\usage{
getCMapConditions(
  metadata,
  cellLine = NULL,
  timepoint = NULL,
  dosage = NULL,
  perturbationType = NULL,
  control = FALSE
)
}
\arguments{
\item{metadata}{Data frame (CMap metadata) or character (respective filepath)}

\item{cellLine}{Character: cell line (if \code{NULL}, all values are loaded)}

\item{timepoint}{Character: timepoint (if \code{NULL}, all values are loaded)}

\item{dosage}{Character: dosage (if \code{NULL}, all values are loaded)}

\item{perturbationType}{Character: type of perturbation (if \code{NULL}, all
perturbation types are loaded)}

\item{control}{Boolean: show controls for perturbation types?}
}
\value{
List of conditions in CMap datasets
}
\description{
Downloads metadata if not available
}
\examples{
\dontrun{
cmapMetadata <- loadCMapData("cmapMetadata.txt", "metadata")
}
getCMapConditions(cmapMetadata)
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{filterCMapMetadata}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapData}()},
\code{\link{loadCMapZscores}()},
\code{\link{parseCMapID}()},
\code{\link{plot.perturbationChanges}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{prepareCMapPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}
}
\concept{functions related with the ranking of CMap perturbations}
