% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTRAP-package.r
\docType{data}
\name{cmapPerturbationsKD}
\alias{cmapPerturbationsKD}
\title{CMap perturbations sample for knockdown experiments}
\description{
CMap perturbations sample for knockdown experiments obtained by running the
following code:

\preformatted{
# Code for loading CMap gene KD HepG2 data
cellLine <- "HepG2"
cmapMetadataKD <- filterCMapMetadata(
  "cmapMetadata.txt", cellLine=cellLine,
  perturbationType="Consensus signature from shRNAs targeting the same gene")

cmapPerturbationsKD <- prepareCMapPerturbations(
  cmapMetadataKD, "cmapZscores.gctx", "cmapGeneInfo.txt",
  loadZscores=TRUE)

data("diffExprStat")
compareKD <- rankSimilarPerturbations(diffExprStat, cmapPerturbationsKD)

# Select only some perturbations (to reduce file size)
filter <- c(head(order(compareKD$spearman_rank)),
            tail(order(compareKD$spearman_rank)),
            head(order(compareKD$pearson_rank)),
            tail(order(compareKD$pearson_rank)),
            head(order(compareKD$gsea_rank)),
            tail(order(compareKD$gsea_rank)))
filter <- unique(compareKD[[1]][filter])
cmapPerturbationsKD <- cmapPerturbationsKD[ , filter]

# Remove non-ASCII characters for portability reasons
metadata <- attr(cmapPerturbationsKD, "metadata")
metadata$pert_idose <- gsub("\u00B5", "micro", metadata$pert_idose)
metadata$pert_dose_unit <- gsub("\u00B5", "micro", metadata$pert_dose_unit)
attr(cmapPerturbationsKD, "metadata") <- metadata
}
}
\keyword{internal}
