% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugSetEnrichment.R
\name{analyseDrugSetEnrichment}
\alias{analyseDrugSetEnrichment}
\title{Analyse drug set enrichment}
\usage{
analyseDrugSetEnrichment(
  sets,
  stats,
  col = NULL,
  nperm = 10000,
  maxSize = 500,
  ...,
  keyColSets = NULL,
  keyColStats = NULL
)
}
\arguments{
\item{sets}{Named list of characters: named sets containing compound
identifiers (obtain drug sets by running \code{prepareDrugSets()})}

\item{stats}{Named numeric vector or either a \code{similarPerturbations} or
a \code{targetingDrugs} object (obtained after running
\code{\link{rankSimilarPerturbations}} or
\code{\link{predictTargetingDrugs}}, respectively)}

\item{col}{Character: name of the column to use for statistics (only required
if class of \code{stats} is either \code{similarPerturbations} or
\code{targetingDrugs})}

\item{nperm}{Number of permutations to do. Minimial possible nominal p-value is about 1/nperm}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{...}{
  Arguments passed on to \code{\link[fgsea:fgseaSimple]{fgsea::fgseaSimple}}
  \describe{
    \item{\code{minSize}}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}
    \item{\code{scoreType}}{This parameter defines the GSEA score type.
Possible options are ("std", "pos", "neg").
By default ("std") the enrichment score is computed as in the original GSEA.
The "pos" and "neg" score types are intended to be used for one-tailed tests
(i.e. when one is interested only in positive ("pos") or negateive ("neg") enrichment).}
    \item{\code{nproc}}{If not equal to zero sets BPPARAM to use nproc workers (default = 0).}
    \item{\code{gseaParam}}{GSEA parameter value, all gene-level statis are raised to the power of `gseaParam`
before calculation of GSEA enrichment scores.}
    \item{\code{BPPARAM}}{Parallelization parameter used in bplapply.
Can be used to specify cluster to run. If not initialized explicitly or
by setting `nproc` default value `bpparam()` is used.}
  }}

\item{keyColSets}{Character: column from \code{sets} to compare with column
\code{keyColStats} from \code{stats}; automatically selected if \code{NULL}}

\item{keyColStats}{Character: column from \code{stats} to compare with column
\code{keyColSets} from \code{sets}; automatically selected if \code{NULL}}
}
\value{
Enrichment analysis based on GSEA
}
\description{
Analyse drug set enrichment
}
\examples{
descriptors <- loadDrugDescriptors()
drugSets <- prepareDrugSets(descriptors)

# Analyse drug set enrichment in ranked targeting drugs for a differential
# expression profile
data("diffExprStat")
gdsc      <- loadExpressionDrugSensitivityAssociation("GDSC")
predicted <- predictTargetingDrugs(diffExprStat, gdsc)

analyseDrugSetEnrichment(drugSets, predicted)
}
\seealso{
Other functions for drug set enrichment analysis: 
\code{\link{loadDrugDescriptors}()},
\code{\link{plotDrugSetEnrichment}()},
\code{\link{prepareDrugSets}()}
}
\concept{functions for drug set enrichment analysis}
