% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{removeReadPileupSpikes}
\alias{removeReadPileupSpikes}
\title{Remove large spikes in short reads coverage}
\usage{
removeReadPileupSpikes(gr = NULL, max.pileup = 30)
}
\arguments{
\item{gr}{A \code{\link{GRanges-class}} object.}

\item{max.pileup}{A maximum number of reads overlapping each other to be kept.}
}
\value{
A \code{\link{GRanges-class}} object.
}
\description{
This function takes a \code{\link{GRanges-class}} object of aligned short reads
and removes pockets of reads that are stacked on top of each other based on the 
maximum number of reads allowed to pileup in 'max.pileup' parameter.
}
\examples{
## Get some files that you want to load
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
infile <- list.files(exampleFolder, full.names=TRUE)[1]
## Read in the reads
breakP.obj <- get(load(infile))
frags <- breakP.obj$fragments 
## Remove read spikes
frags <- removeReadPileupSpikes(gr=frags)

}
\author{
David Porubsky
}
