% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenotypeBreaks.R
\name{genotype.fisher}
\alias{genotype.fisher}
\title{Assign states to any given region using Fisher Exact Test.}
\usage{
genotype.fisher(cReads, wReads, roiReads, background = 0.05, minReads = 10)
}
\arguments{
\item{cReads}{Number of Crick reads.}

\item{wReads}{Number of Watson reads.}

\item{roiReads}{Total number of Crick and Watson reads.}

\item{background}{The percent (e.g. 0.05 = 5\%) of background reads allowed for WW or CC genotype calls.}

\item{minReads}{The minimal number of reads between two breaks required for genotyping.}
}
\value{
A \code{list} with the $bestFit and $pval.
}
\description{
Assign states to any given region using Fisher Exact Test.
}
\examples{
## Get Crick and Watson read counts
## Crick read count
cReads <- 30
## Watson read count
wReads <- 5  
genotype.fisher(cReads = cReads, wReads = wReads, roiReads = cReads + wReads, background = 0.05, minReads = 10)

}
\author{
David Porubsky, Aaron Taudt
}
