# annotate_sce
test_that("throws error if sce param is not a SingleCellExperiment", {
    not_an_sce <- data.frame()
    mapping_results <- list(generate_test_mapping_result())

    tmp1 <- function() annotate_sce(not_an_sce, blase_results = mapping_results)
    expect_error(tmp1(), "SCE must be a Single Cell Experiment object.\n", fixed = TRUE)
})

test_that("throws error if sce does not include pseudotime_bin column", {
    sce <- generate_test_sce()
    sce$pseudotime_bin <- NULL
    mapping_results <- list(generate_test_mapping_result())

    tmp1 <- function() annotate_sce(sce, blase_results = mapping_results)
    expect_error(tmp1(), "SCE must have pseudotime_bin slot populated.\n", fixed = TRUE)
})

test_that("throws error if mapping results list not all mapping results", {
    sce <- generate_test_sce()
    sce$pseudotime_bin <- 1
    not_mapping_results <- list(generate_test_mapping_result(), 5)

    tmp1 <- function() annotate_sce(sce, blase_results = not_mapping_results)
    expect_error(tmp1(), "BLASE Results must be a list of MappingResults generated by BLASE.\n", fixed = TRUE)
})


test_that("adds mapping to sce with default column", {
    sce <- generate_test_sce()
    sce$pseudotime_bin <- 1
    mappings <- list(generate_test_mapping_result())

    sce <- annotate_sce(sce, mappings)

    expect_true(all(sce$BLASE_Annotation == "Test"))
})

test_that("adds mapping to sce with customised column", {
    sce <- generate_test_sce()
    sce$pseudotime_bin <- 1
    mappings <- list(generate_test_mapping_result())

    sce <- annotate_sce(sce, mappings, annotation_col = "CUSTOM_COL")

    expect_true(all(sce$CUSTOM_COL == "Test"))
    expect_true(is.null(sce$BLASE_Annotation))
})

test_that("adds stats to sce if flag enabled", {
    sce <- generate_test_sce()
    sce$pseudotime_bin <- 1
    mappings <- list(generate_test_mapping_result())

    sce <- annotate_sce(sce, mappings, include_stats = TRUE)

    expect_true(all(sce$BLASE_Annotation_Correlation == 0.5))
})

test_that("does not add stats to sce if flag disabled", {
    sce <- generate_test_sce()
    sce$pseudotime_bin <- 1
    mappings <- list(generate_test_mapping_result())

    sce <- annotate_sce(sce, mappings, include_stats = FALSE)
    expect_true(is.null(sce$BLASE_Annotation_Correlation))
})
