% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{plot_find_best_params_results}
\alias{plot_find_best_params_results}
\title{Plot the results of the search for good parameters}
\usage{
plot_find_best_params_results(
  find_best_params_results,
  bin_count_colors = viridis::scale_color_viridis(option = "viridis"),
  gene_count_colors = viridis::scale_color_viridis(option = "magma")
)
}
\arguments{
\item{find_best_params_results}{Dataframe. Results dataframe from
\code{\link[=find_best_params]{find_best_params()}}}

\item{bin_count_colors}{Optional, custom bin count scale color scheme.}

\item{gene_count_colors}{Optional, custom gene count scale color scheme.}
}
\value{
A plot showing how convexity changes as n_bins and n_genes
are changed. See \code{\link[=find_best_params]{find_best_params()}} for details on how to interpret.
}
\description{
Plot the results of the search for good parameters
}
\examples{
ncells <- 70
ngenes <- 100
counts_matrix <- matrix(
    c(seq_len(3500) / 10, seq_len(3500) / 5),
    ncol = ncells,
    nrow = ngenes
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    normcounts = counts_matrix, logcounts = log(counts_matrix)
))
colnames(sce) <- paste0("cell", seq_len(ncells))
rownames(sce) <- paste0("gene", seq_len(ngenes))
sce$cell_type <- c(
    rep("celltype_1", ncells / 2),
    rep("celltype_2", ncells / 2)
)

sce$pseudotime <- seq_len(ncells) - 1
genelist <- rownames(sce)

# Finding the best params for the BlaseData
best_params <- find_best_params(
    sce, genelist,
    bins_count_range = c(2, 3),
    gene_count_range = c(20, 50),
    pseudotime_slot = "pseudotime",
    split_by = "pseudotime_range"
)
best_params
plot_find_best_params_results(best_params)
}
\seealso{
\code{\link[=find_best_params]{find_best_params()}}
}
\concept{tuning}
