% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blase_data_conversion.R
\name{as.BlaseData}
\alias{as.BlaseData}
\alias{as.BlaseData,SingleCellExperiment-method}
\title{Conversion to BlaseData}
\usage{
as.BlaseData(x, ...)

\S4method{as.BlaseData}{SingleCellExperiment}(
  x,
  pseudotime_slot = "slingPseudotime_1",
  n_bins = 20,
  split_by = "pseudotime_range"
)
}
\arguments{
\item{x}{An object to take counts from}

\item{...}{additional arguments passed to object-specific methods.}

\item{pseudotime_slot}{The \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}
slot containing pseudotime values for each cell to be passed to
\code{\link[=assign_pseudotime_bins]{assign_pseudotime_bins()}}.}

\item{n_bins}{Integer. The number of bins to create, passed to
\code{\link[=assign_pseudotime_bins]{assign_pseudotime_bins()}}.}

\item{split_by}{String. The split_by method to be passed on to
\code{\link[=assign_pseudotime_bins]{assign_pseudotime_bins()}}. Must be one of \code{pseudotime_range} or \code{cells}.}
}
\value{
An \link{BlaseData} object
}
\description{
Conversion to BlaseData
}
\examples{
counts <- matrix(rpois(100, lambda = 10), ncol = 10, nrow = 10)
sce <- SingleCellExperiment::SingleCellExperiment(
    assays = list(normcounts = counts)
)
sce$pseudotime <- seq_len(10) - 1
data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 3)
genes(data) <- as.character(seq_len(10))

genes(data)
}
\concept{blase-object}
