% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blase_data_class.R
\name{pseudobulk_bins}
\alias{pseudobulk_bins}
\alias{pseudobulk_bins,BlaseData-method}
\title{Get pseudobulk bins of a BLASE Data object.}
\usage{
pseudobulk_bins(x)

\S4method{pseudobulk_bins}{BlaseData}(x)
}
\arguments{
\item{x}{a \link{BlaseData} object}
}
\value{
List of dataframes. Each dataframe is the normalised counts of
cells by genes in each pseudotime bin. List index is the pseudotime bin.
}
\description{
Get pseudobulk bins of a BLASE Data object.
}
\examples{
counts <- matrix(rpois(100, lambda = 10), ncol = 10, nrow = 10)
sce <- SingleCellExperiment::SingleCellExperiment(
    assays = list(normcounts = counts)
)
sce$pseudotime <- seq_len(10) - 1
data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 3)
genes(data) <- as.character(seq_len(10))

genes(data)
}
\concept{blase-object}
\keyword{internal}
