% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping_result_plotting.R
\name{plot_mapping_result}
\alias{plot_mapping_result}
\alias{plot_mapping_result,SingleCellExperiment,MappingResult-method}
\title{Plot a summary of the mapping result}
\usage{
plot_mapping_result(x, y, ...)

\S4method{plot_mapping_result}{SingleCellExperiment,MappingResult}(x, y, group_by_slot)
}
\arguments{
\item{x}{An object to plot on.}

\item{y}{The \link{MappingResult} object to plot}

\item{...}{additional arguments passed to object-specific methods.}

\item{group_by_slot}{String. The metadata column in the
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} to be used as the coloring
for the output plot. Passed to \code{\link[scater:plot_reddim]{scater::plotUMAP()}} as
\code{colour_by}, and will be used to produce a bar chart of
populations in the best mapped bin.}
}
\value{
A set of plots describing the mapping.
}
\description{
Plot a summary of the mapping result
}
\examples{
counts_matrix <- matrix(
    c(seq_len(120) / 10, seq_len(120) / 5),
    ncol = 48, nrow = 5
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    normcounts = counts_matrix, logcounts = log(counts_matrix)
))
colnames(sce) <- seq_len(48)
rownames(sce) <- as.character(seq_len(5))
sce$cell_type <- c(rep("celltype_1", 24), rep("celltype_2", 24))

sce$pseudotime <- seq_len(48) - 1
blase_data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 4)
genes(blase_data) <- as.character(seq_len(5))

bulk_counts <- matrix(seq_len(15) * 10, ncol = 3, nrow = 5)
colnames(bulk_counts) <- c("A", "B", "C")
rownames(bulk_counts) <- as.character(seq_len(5))

result <- map_best_bin(blase_data, "B", bulk_counts)

# Plot bin
sce <- scater::runUMAP(sce)
sce <- assign_pseudotime_bins(
    sce,
    pseudotime_slot = "pseudotime", n_bins = 4
)
plot_mapping_result(sce, result, group_by_slot = "cell_type")

}
\seealso{
\code{\link[=plot_mapping_result_corr]{plot_mapping_result_corr()}}, \code{\link[=plot_bin_population]{plot_bin_population()}}
}
\concept{mapping_plots}
