% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_selection.R
\name{get_top_n_genes}
\alias{get_top_n_genes}
\title{Get Top Genes From An AssociationTestResult}
\usage{
get_top_n_genes(
  association_test_results,
  n_genes = 40,
  lineage = NA,
  p_cutoff = 0.05
)
}
\arguments{
\item{association_test_results}{Dataframe. The association
test results data frame to take the genes from. Generated
by \link[tradeSeq:associationTest]{tradeSeq::associationTest}.}

\item{n_genes}{Integer. The number of genes to return. Defaults to 40.}

\item{lineage}{The Lineage to use. The Defaults to NA, which assumes
the test was run with \code{Lineages=False}.}

\item{p_cutoff}{Decimal. The maximum P value cutoff to use.
Defaults to 0.05.}
}
\value{
A vector of strings. The names of the genes that best describe
a lineage's trajectory.
}
\description{
Pulls the genes with the highest wald statistic from an association
test result, with a p value cutoff.
}
\examples{
assoRes <- data.frame(
    row.names = c("A", "B", "C", "D"),
    waldStat = c(25, 50, 100, 10),
    pvalue = c(0.01, 0.5, 0.005, 0.13)
)
get_top_n_genes(assoRes, n_genes = 2)
}
\concept{gene-selection}
