% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blase_data_class.R
\name{bins}
\alias{bins}
\alias{bins,BlaseData-method}
\title{Get bins of a BLASE Data object.}
\usage{
bins(x)

\S4method{bins}{BlaseData}(x)
}
\arguments{
\item{x}{a \link{BlaseData} object}
}
\value{
vector of integers. The bin names in the
BLASE Data object.
}
\description{
Get bins of a BLASE Data object.
}
\examples{
counts <- matrix(rpois(100, lambda = 10), ncol = 10, nrow = 10)
sce <- SingleCellExperiment::SingleCellExperiment(
    assays = list(normcounts = counts)
)
sce$pseudotime <- seq_len(10) - 1
data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 3)
genes(data) <- as.character(seq_len(10))

genes(data)
}
\concept{blase-object}
\keyword{internal}
