% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping_result_class.R
\docType{class}
\name{MappingResult}
\alias{MappingResult}
\alias{MappingResult-class}
\title{Blase Mapping Result}
\usage{
MappingResult(
  bulk_name,
  best_bin,
  best_correlation,
  top_2_distance,
  confident_mapping,
  history,
  bootstrap_iterations
)
}
\arguments{
\item{bulk_name}{String. The name of the bulk sample being mapped.}

\item{best_bin}{Integer. The bin that best matched the bulk sample.}

\item{best_correlation}{Decimal. The spearman's rho that the test geneset had
between the winning bin and the bulk.}

\item{top_2_distance}{Decimal. The absolute difference between the best and
second best mapping buckets. Higher indicates a less doubtful mapping.}

\item{confident_mapping}{Boolean. TRUE when the mapped bin's lower
bound is higher than the maximum upper bound of the other bins.}

\item{history}{A dataframe of the correlation score (decimal) and
confidence bounds (decimal pairs) for each bin.
Access with \code{mapping_history()}}

\item{bootstrap_iterations}{Integer. The number of iterations used during
the bootstrap.}
}
\value{
A MappingResult object
}
\description{
Created by \code{\link[=map_best_bin]{map_best_bin()}}
}
\examples{
counts_matrix <- matrix(
    c(seq_len(120) / 10, seq_len(120) / 5),
    ncol = 48, nrow = 5
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    normcounts = counts_matrix, logcounts = log(counts_matrix)
))
colnames(sce) <- seq_len(48)
rownames(sce) <- as.character(seq_len(5))
sce$cell_type <- c(rep("celltype_1", 24), rep("celltype_2", 24))

sce$pseudotime <- seq_len(48) - 1
blase_data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 4)
genes(blase_data) <- as.character(seq_len(5))

bulk_counts <- matrix(seq_len(15) * 10, ncol = 3, nrow = 5)
colnames(bulk_counts) <- c("A", "B", "C")
rownames(bulk_counts) <- as.character(seq_len(5))

# Map to bin
result <- map_best_bin(blase_data, "B", bulk_counts)
result

# Map all bulks to bin
results <- map_all_best_bins(blase_data, bulk_counts)

# Plot Heatmap
plot_mapping_result_heatmap(list(result))

# Plot Correlation
plot_mapping_result_corr(result)

# Plot populations
sce <- assign_pseudotime_bins(
    sce,
    pseudotime_slot = "pseudotime", n_bins = 4
)
plot_bin_population(sce, best_bin(result), group_by_slot = "cell_type")

# Getters
bulk_name(result)
best_bin(result)
best_correlation(result)
top_2_distance(result)
confident_mapping(result)
mapping_history(result)
bootstrap_iterations(result)
}
\seealso{
\code{\link[=map_best_bin]{map_best_bin()}}
}
\concept{mapping-result-object}
