% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomaRt.R
\name{useDataset}
\alias{useDataset}
\title{Select a dataset to use and updates Mart object}
\usage{
useDataset(dataset, mart, verbose = FALSE)
}
\arguments{
\item{dataset}{Dataset you want to use.  List of possible datasets can be
retrieved using the function \code{\link[=listDatasets]{listDatasets()}}}

\item{mart}{Mart object created with the \code{\link[=useMart]{useMart()}} function}

\item{verbose}{Give detailed output of what the method is doing, for
debugging}
}
\description{
This function selects a dataset and updates the Mart object
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
mart <- useMart("ENSEMBL_MART_ENSEMBL")
mart <- useDataset("hsapiens_gene_ensembl", mart = mart)
\dontshow{\}) # examplesIf}
}
\author{
Steffen Durinck
}
\keyword{methods}
