% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbEntry.R
\name{BiodbEntry}
\alias{BiodbEntry}
\title{The mother abstract class of all database entry classes.}
\description{
The mother abstract class of all database entry classes.

The mother abstract class of all database entry classes.
}
\details{
An entry is an element of a database, identifiable by its accession number.
Each contains a list of fields defined by a name and a value. The details of
all fields that can be set into an entry are defined inside the class
\code{BiodbEntryFields}. From this class are derived other abstract classes
for different types of entry contents: \code{BiodbTxtEntry},
\code{BiodbXmlEntry}, \code{BiodbCsvEntry}, \code{BiodbJsonEntry} and
\code{BiodbHtmlEntry}. Then concrete classes are derived for each database:
\code{CompCsvEntry}, \code{MassCsvEntry}, etc. For biodb users, there is no
need to know this hierarchy; the knowledge of this class and its methods is
sufficient.
}
\examples{
# Create an instance with default settings:
mybiodb <- biodb::newInst()

# Get a compound CSV file database
chebi.tsv <- system.file("extdata", "chebi_extract.tsv", package='biodb')

# Get the connector of a compound database
conn <- mybiodb$getFactory()$createConn('comp.csv.file', url=chebi.tsv)

# Get an entry:
entry <- conn$getEntry(conn$getEntryIds(1))

# Get all defined fields:
entry$getFieldNames()

# Get a field value:
accession <- entry$getFieldValue('accession')

# Test if a field is defined:
if (entry$hasField('name'))
  print(paste("The entry's name is ", entry$getFieldValue('name'),
  '.', sep=''))

# Export an entry as a data frame:
df <- entry$getFieldsAsDataframe()

# You can set or reset a field's value:
entry$setFieldValue('mass', 1893.1883)

# Terminate instance.
mybiodb$terminate()

}
\seealso{
\code{\link{BiodbFactory}}, \code{\link{BiodbConn}},
\code{\link{BiodbEntryFields}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbEntry-new}{\code{BiodbEntry$new()}}
\item \href{#method-BiodbEntry-parentIsAConnector}{\code{BiodbEntry$parentIsAConnector()}}
\item \href{#method-BiodbEntry-getParent}{\code{BiodbEntry$getParent()}}
\item \href{#method-BiodbEntry-getBiodb}{\code{BiodbEntry$getBiodb()}}
\item \href{#method-BiodbEntry-cloneInstance}{\code{BiodbEntry$cloneInstance()}}
\item \href{#method-BiodbEntry-getId}{\code{BiodbEntry$getId()}}
\item \href{#method-BiodbEntry-isNew}{\code{BiodbEntry$isNew()}}
\item \href{#method-BiodbEntry-getDbClass}{\code{BiodbEntry$getDbClass()}}
\item \href{#method-BiodbEntry-setFieldValue}{\code{BiodbEntry$setFieldValue()}}
\item \href{#method-BiodbEntry-appendFieldValue}{\code{BiodbEntry$appendFieldValue()}}
\item \href{#method-BiodbEntry-getFieldNames}{\code{BiodbEntry$getFieldNames()}}
\item \href{#method-BiodbEntry-hasField}{\code{BiodbEntry$hasField()}}
\item \href{#method-BiodbEntry-removeField}{\code{BiodbEntry$removeField()}}
\item \href{#method-BiodbEntry-getFieldValue}{\code{BiodbEntry$getFieldValue()}}
\item \href{#method-BiodbEntry-getFieldsByType}{\code{BiodbEntry$getFieldsByType()}}
\item \href{#method-BiodbEntry-getFieldsAsDataframe}{\code{BiodbEntry$getFieldsAsDataframe()}}
\item \href{#method-BiodbEntry-getFieldsAsJson}{\code{BiodbEntry$getFieldsAsJson()}}
\item \href{#method-BiodbEntry-parseContent}{\code{BiodbEntry$parseContent()}}
\item \href{#method-BiodbEntry-computeFields}{\code{BiodbEntry$computeFields()}}
\item \href{#method-BiodbEntry-print}{\code{BiodbEntry$print()}}
\item \href{#method-BiodbEntry-getName}{\code{BiodbEntry$getName()}}
\item \href{#method-BiodbEntry-makesRefToEntry}{\code{BiodbEntry$makesRefToEntry()}}
\item \href{#method-BiodbEntry-getField}{\code{BiodbEntry$getField()}}
\item \href{#method-BiodbEntry-setField}{\code{BiodbEntry$setField()}}
\item \href{#method-BiodbEntry-getFieldClass}{\code{BiodbEntry$getFieldClass()}}
\item \href{#method-BiodbEntry-getFieldDef}{\code{BiodbEntry$getFieldDef()}}
\item \href{#method-BiodbEntry-getFieldCardinality}{\code{BiodbEntry$getFieldCardinality()}}
\item \href{#method-BiodbEntry-fieldHasBasicClass}{\code{BiodbEntry$fieldHasBasicClass()}}
\item \href{#method-BiodbEntry-clone}{\code{BiodbEntry$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. Entry objects must not be created directly.
Instead, they are retrieved through the connector instances.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$new(parent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{A valid BiodbConn instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-parentIsAConnector"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-parentIsAConnector}{}}}
\subsection{Method \code{parentIsAConnector()}}{
Tests if the parent of this entry is a connector instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$parentIsAConnector()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if this entry belongs to a connector, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getParent"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getParent}{}}}
\subsection{Method \code{getParent()}}{
Returns the parent instance (A BiodbConn or BiodbFactory object) to which
this object is attached.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getParent()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A BiodbConn instance or a BiodbFactory object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getBiodb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getBiodb}{}}}
\subsection{Method \code{getBiodb()}}{
Returns the biodb main class instance to which this object is
attached.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getBiodb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The main biodb instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-cloneInstance"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-cloneInstance}{}}}
\subsection{Method \code{cloneInstance()}}{
Clones this entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$cloneInstance(db.class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.class}}{The database class (the Biodb database ID) of the
clone. By setting this parameter, you can specify a different database
for the clone, so you may clone an entry into another database if you
wish. By default the class of the clone will be the same as the
original entry.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The clone, as a new BiodbEntry instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getId"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getId}{}}}
\subsection{Method \code{getId()}}{
Gets the entry ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the entry ID, which is the value if the \code{accession} field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-isNew"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-isNew}{}}}
\subsection{Method \code{isNew()}}{
Tests if this entry is new.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$isNew()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if this entry was newly created, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getDbClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getDbClass}{}}}
\subsection{Method \code{getDbClass()}}{
Gets the ID of the database associated with this entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getDbClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of the database class associated with this entry.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-setFieldValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-setFieldValue}{}}}
\subsection{Method \code{setFieldValue()}}{
Sets the value of a field. If the field is not already set for this
entry, then the field will be created. See BiodbEntryFields for a list of
possible fields in biodb.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$setFieldValue(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of a field.}

\item{\code{value}}{The value to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-appendFieldValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-appendFieldValue}{}}}
\subsection{Method \code{appendFieldValue()}}{
Appends a value to an existing field. If the field is not defined for
this entry, then the field will be created and set to this value. Only
fields with a cardinality greater than one can accept multiple values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$appendFieldValue(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of a field.}

\item{\code{value}}{The value to append.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldNames"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldNames}{}}}
\subsection{Method \code{getFieldNames()}}{
Gets a list of all fields defined for this entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector containing all field names defined in
this entry.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-hasField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-hasField}{}}}
\subsection{Method \code{hasField()}}{
Tests if a field is defined in this entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$hasField(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of a field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the specified field is defined in this entry,
FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-removeField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-removeField}{}}}
\subsection{Method \code{removeField()}}{
Removes the specified field from this entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$removeField(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of a field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldValue}{}}}
\subsection{Method \code{getFieldValue()}}{
Gets the value of the specified field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldValue(
  field,
  compute = TRUE,
  flatten = FALSE,
  last = FALSE,
  limit = 0,
  withNa = TRUE,
  duplicatedValues = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of a field.}

\item{\code{compute}}{If set to TRUE and a field is not defined, try to compute it
using internal defined computing rules. If set to FALSE, let the field
undefined.}

\item{\code{flatten}}{If set to TRUE and a field's value is a vector of more than
one element, then export the field's value as a single string composed of
the field's value concatenated and separated by the character defined in the
'multival.field.sep' config key. If set to FALSE or the field contains only
one value, changes nothing.}

\item{\code{last}}{If set to TRUE and a field's value is a vector of more than one
element, then export only the last value. If set to FALSE, changes nothing.}

\item{\code{limit}}{The maximum number of values to get in case the field contains
more than one value.}

\item{\code{withNa}}{If set to TRUE, keep NA values. Otherwise filter out NAs
values in vectors.}

\item{\code{duplicatedValues}}{If set to TRUE, keeps duplicated values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value of the field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldsByType"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldsByType}{}}}
\subsection{Method \code{getFieldsByType()}}{
Gets the fields of this entry that have the specified type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldsByType(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type of fields to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing the field names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldsAsDataframe"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldsAsDataframe}{}}}
\subsection{Method \code{getFieldsAsDataframe()}}{
Converts this entry into a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldsAsDataframe(
  only.atomic = TRUE,
  compute = TRUE,
  fields = NULL,
  fields.type = NULL,
  flatten = TRUE,
  limit = 0,
  only.card.one = FALSE,
  own.id = TRUE,
  duplicate.rows = TRUE,
  sort = FALSE,
  virtualFields = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{only.atomic}}{If set to TRUE, only export field's values that are atomic}

\item{\code{compute}}{If set to TRUE and a field is not defined, try to compute it
using internal defined computing rules. If set to FALSE, let the field
undefined.}

\item{\code{fields}}{Set to character vector of field names in order to restrict
execution to this set of fields.}

\item{\code{fields.type}}{If set, output all the fields of the specified type.}

\item{\code{flatten}}{If set to TRUE and a field's value is a vector of more than
one element, then export the field's value as a single string composed of
the field's value concatenated and separated by the character defined in the
'multival.field.sep' config key. If set to FALSE or the field contains only
one value, changes nothing.}

\item{\code{limit}}{The maximum number of field values to write into new columns.
Used for fields that can contain more than one value.}

\item{\code{only.card.one}}{If set to TRUE, only fields with a cardinality of one
will be extracted.}

\item{\code{own.id}}{If set to TRUE includes the database id field named
\verb{<database_name>.id} whose values are the same as the \code{accession} field.}

\item{\code{duplicate.rows}}{If set to TRUE and merging field values with
cardinality greater than one, values will be duplicated.}

\item{\code{sort}}{If set to TRUE sort the order of columns alphabetically,
otherwise do not sort.}

\item{\code{virtualFields}}{If set to TRUE includes also virtual fields, otherwise
excludes them.}

\item{\code{(i.e.}}{of type vector).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containg the values of the fields.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldsAsJson"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldsAsJson}{}}}
\subsection{Method \code{getFieldsAsJson()}}{
Converts this entry into a JSON string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldsAsJson(compute = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compute}}{If set to TRUE and a field is not defined, try to compute it
using internal defined computing rules. If set to FALSE, let the field
undefined.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A JSON object from jsonlite package.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-parseContent"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-parseContent}{}}}
\subsection{Method \code{parseContent()}}{
Parses content string and set values accordingly for this entry's
fields.  This method is called automatically and should be run directly
by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$parseContent(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{A character string containing definition for an entry and}

\item{\code{obtained}}{from a database. The format can be CSV, HTML, JSON,
XML, or just text.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-computeFields"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-computeFields}{}}}
\subsection{Method \code{computeFields()}}{
Computes fields. Look at all missing fields, and try to compute them
using references to other databases, if a rule exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$computeFields(fields = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{A list of fields to review for computing. By default all fields
will be reviewed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if at least one field was computed successfully,
FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-print}{}}}
\subsection{Method \code{print()}}{
Displays short information about this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getName}{}}}
\subsection{Method \code{getName()}}{
Gets a short text describing this entry instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character value concatenating the connector name with
the entry accession.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-makesRefToEntry"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-makesRefToEntry}{}}}
\subsection{Method \code{makesRefToEntry()}}{
Tests if this entry makes reference to another entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$makesRefToEntry(db, oid, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db}}{Another database connector.}

\item{\code{oid}}{A entry ID from database db.}

\item{\code{recurse}}{If set to TRUE, the algorithm will follow all references to
entries from other databases, to see if it can establish an indirect link to
\code{oid}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if this entry makes reference to the entry oid from database
db, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getField}{}}}
\subsection{Method \code{getField()}}{
DEPRECATED. Gets the value of a field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getField(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value of the field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-setField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-setField}{}}}
\subsection{Method \code{setField()}}{
DEPRECATED. Sets the value of a field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$setField(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}

\item{\code{value}}{The new value of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldClass}{}}}
\subsection{Method \code{getFieldClass()}}{
Gets the class of a field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldClass(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The class of the field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldDef"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldDef}{}}}
\subsection{Method \code{getFieldDef()}}{
Gets the definition of an entry field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldDef(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object BiodbEntryField which defines the field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-getFieldCardinality"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-getFieldCardinality}{}}}
\subsection{Method \code{getFieldCardinality()}}{
Gets the cardinality of the field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$getFieldCardinality(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cardinality of the field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-fieldHasBasicClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-fieldHasBasicClass}{}}}
\subsection{Method \code{fieldHasBasicClass()}}{
DEPRECATED. Use BiodbEntryField::isVector() instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$fieldHasBasicClass(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the field as a basic type (logical, numeric, character, ...).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntry-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntry-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntry$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
