% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbDbsInfo.R
\name{BiodbDbsInfo}
\alias{BiodbDbsInfo}
\title{A class for describing the available databases.}
\description{
A class for describing the available databases.

A class for describing the available databases.
}
\details{
The unique instance of this class is handle by the \code{\link{BiodbMain}}
class and accessed through the \code{getDbsInfo()} method.
}
\examples{
# Create an instance with default settings:
mybiodb <- biodb::newInst()

# Getting the entry content type of a database:
db.inf <- mybiodb$getDbsInfo()$get('comp.csv.file')
cont.type <- db.inf$getPropertyValue('entry.content.type')

# Terminate instance.
mybiodb$terminate()

}
\seealso{
\code{\link{BiodbMain}} and child class \code{\link{BiodbDbInfo}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbDbsInfo-new}{\code{BiodbDbsInfo$new()}}
\item \href{#method-BiodbDbsInfo-define}{\code{BiodbDbsInfo$define()}}
\item \href{#method-BiodbDbsInfo-getIds}{\code{BiodbDbsInfo$getIds()}}
\item \href{#method-BiodbDbsInfo-isDefined}{\code{BiodbDbsInfo$isDefined()}}
\item \href{#method-BiodbDbsInfo-checkIsDefined}{\code{BiodbDbsInfo$checkIsDefined()}}
\item \href{#method-BiodbDbsInfo-get}{\code{BiodbDbsInfo$get()}}
\item \href{#method-BiodbDbsInfo-getAll}{\code{BiodbDbsInfo$getAll()}}
\item \href{#method-BiodbDbsInfo-print}{\code{BiodbDbsInfo$print()}}
\item \href{#method-BiodbDbsInfo-clone}{\code{BiodbDbsInfo$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. The class must not be instantiated directly.
Instead, access the BiodbDbsInfo instance through the BiodbMain instance
using the getDbsInfo() method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$new(cfg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cfg}}{The BiodbConfig instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-define"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-define}{}}}
\subsection{Method \code{define()}}{
Define databases from a structured object, normally loaded from a YAML
file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$define(def, package = "biodb")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{def}}{A named list of database definitions. The names of the list
will be the IDs of the databases.}

\item{\code{package}}{The package to which belong the new definitions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-getIds"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-getIds}{}}}
\subsection{Method \code{getIds()}}{
Gets the database IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$getIds()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector containing all the IDs of the defined
databases.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-isDefined"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-isDefined}{}}}
\subsection{Method \code{isDefined()}}{
Tests if a database is defined.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$isDefined(db.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.id}}{A database ID, as a character string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the specified id corresponds to a defined
database, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-checkIsDefined"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-checkIsDefined}{}}}
\subsection{Method \code{checkIsDefined()}}{
Checks if a database is defined. Throws an error if the specified id
does not correspond to a defined database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$checkIsDefined(db.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.id}}{A character vector of database IDs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-get"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-get}{}}}
\subsection{Method \code{get()}}{
Gets information on a database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$get(db.id = NULL, drop = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.id}}{Database IDs, as a character vector. If set to NULL,
informations on all databases will be returned.}

\item{\code{drop}}{If TRUE and only one database ID has been submitted,
returns a single BiodbDbInfo instance instead of a list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of BiodbDbInfo instances corresponding to the specified
database IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-getAll"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-getAll}{}}}
\subsection{Method \code{getAll()}}{
Gets informations on all databases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$getAll()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of all BiodbDbInfo instances."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-print}{}}}
\subsection{Method \code{print()}}{
Prints informations about this instance, listing also all databases
defined.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbDbsInfo-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbDbsInfo-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbDbsInfo$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
