% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_longtests_rcolet.R
\name{block_to_testthat}
\alias{block_to_testthat}
\title{Convert a roxygen2 block to a testthat file}
\usage{
block_to_testthat(block)
}
\arguments{
\item{block}{A roxygen2 block.}
}
\value{
A list representing a testthat file, or NULL if the block has no
'longtests' tags.
}
\description{
This is an internal function that converts a roxygen2 block to a testthat
file. It first checks if the block has any 'longtests' tags. If not, it
returns NULL. Then, it extracts the 'longtests' and 'examples' tags from the
block and assigns them to the 'longtests' and 'examples' fields of the
testthat file, respectively. It also assigns the basename of the block's file
to the 'filename' field, and the alias of the block's object to the
'functionname' field. If the block's line is not NULL, it appends it to the
'functionname' field.
}
\keyword{internal}
