
<!-- README.md is generated from README.Rmd. Please edit that file -->

# biocroxytest <a href="https://xec-cm.github.io/biocroxytest/"><img src="man/figures/logo.png" align="right" height="138" alt="biocroxytest website" /></a>

<!-- badges: start -->

[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
[![R-CMD-check](https://github.com/xec-cm/biocroxytest/workflows/R-CMD-check-bioc/badge.svg)](https://github.com/xec-cm/biocroxytest/actions)
[![Codecov test
coverage](https://codecov.io/gh/xec-cm/biocroxytest/branch/devel/graph/badge.svg)](https://app.codecov.io/gh/xec-cm/biocroxytest?branch=devel)
[![PRs
Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://makeapullrequest.com)
[![GitHub
issues](https://img.shields.io/github/issues/xec-cm/biocroxytest)](https://github.com/xec-cm/biocroxytest/issues)
[![GitHub
pulls](https://img.shields.io/github/issues-pr/xec-cm/biocroxytest)](https://github.com/xec-cm/biocroxytest/pulls)
<!-- badges: end -->

The *[biocroxytest](https://github.com/xec-cm/biocroxytest)* package is
a novel tool that enhances the efficiency of test writing in R,
particularly for Bioconductor software packages. It leverages the
structure of *[roxygen2](https://github.com/r-lib/roxygen2)* for test
writing, which improves readability, code organization, and integrates
seamlessly with package documentation.

In Bioconductor, daily tests are run as part of the nightly builds, with
a maximum limit of 40 minutes per package. For tests that exceed this
limit, developers can set up “long tests” and add their package to the
Bioconductor Long Tests builds. However, traditionally separating tests
and long tests can be cumbersome.

*[biocroxytest](https://github.com/xec-cm/biocroxytest)* addresses this
issue by introducing a new roclet, `@longtests`, inspired by
*[roxytest](https://github.com/mikldk/roxytest)*. This allows developers
to document and store long tests directly within their
*[roxygen2](https://github.com/r-lib/roxygen2)* comments. By using the
`@longtests` roclet, extensive tests are run and checked regularly
without impacting the efficiency of the daily build process.

The `@longtests` roclet provides a dedicated space for extensive tests,
ensuring they are easily accessible and well-documented. This not only
improves the package’s reliability but also its maintainability. Thus,
*[biocroxytest](https://github.com/xec-cm/biocroxytest)* contributes to
the creation of robust, reliable, and efficient Bioconductor packages.

## Installation instructions

Get the latest stable `R` release from
[CRAN](http://cran.r-project.org/). Then install `biocroxytest` from
[Bioconductor](http://bioconductor.org/) using the following code:

``` r
# Not yet on Bioconductor
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("biocroxytest")
```

And the development version from
[GitHub](https://github.com/xec-cm/biocroxytest) with:

``` r
BiocManager::install("xec-cm/biocroxytest")
```

## Example

Here is how you can use
*[biocroxytest](https://github.com/xec-cm/biocroxytest)* to create a new
package with long tests:

To use the package in your own package you do not need to add any
additional dependencies in your package’s DESCRIPTION file. Simply add
the following lines to your package’s DESCRIPTION file (along with
Suggests: testthat):

    Roxygen: list(roclets = c("namespace", "rd", "biocroxytest::longtests_roclet"))

Then add `@longtests` to the roxygen comments of the functions you want
to test. For example, if the file `R/functions.R` contains this code:

``` r
#' A function to do x
#' 
#' @param x A number
#' 
#' @longtests 
#' expect_equal(foo(2), sqrt(2))
#' expect_error(foo("a string"))
#' 
#' @return something
foo <- function(x) {
  return(sqrt(x))
}

#' A function to do y
#' 
#' @param x Character vector
#' @param y Character vector
#' 
#' @longtests 
#' expect_equal(bar("A", "B"), paste("A", "B", sep = "/"))
#' 
#' @export
bar <- function(x, y) {
  paste0(x, "/", y)
}
```

Then `roxygen2::roxygenise()` will generate (with the `longtests_roclet`
roclet) the file `longtests/test-biocroxytest-tests-functions.R` with
this content:

``` r
# Generated by biocroxytest: do not edit by hand!

# File R/functions.R: @longtests

test_that("Function foo() @ L11", {
  expect_equal(foo(2), sqrt(2))
  expect_error(foo("a string"))
})


test_that("Function bar() @ L27", {
  expect_equal(bar("A", "B"), paste("A", "B", sep = "/"))
})
```

## Contributing

- If you think you have encountered a bug, please [submit an
  issue](https://github.com/xec-cm/biocroxytest/issues).

- Either way, learn how to create and share a
  [reprex](https://reprex.tidyverse.org/articles/articles/learn-reprex.html)
  (a minimal, reproducible example), to clearly communicate about your
  code.

- Working on your first Pull Request? You can learn how from this *free*
  series [How to Contribute to an Open Source Project on
  GitHub](https://kcd.im/pull-request)

## Code of Conduct

Please note that the
*[biocroxytest](https://github.com/xec-cm/biocroxytest)* project is
released with a [Contributor Code of
Conduct](http://bioconductor.org/about/code-of-conduct/). By
contributing to this project, you agree to abide by its terms.
