% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{dmr_identification}
\alias{dmr_identification}
\alias{dmr_identification,dmcResults-method}
\alias{dmr_identification-methods}
\alias{dmr_identification,matrix-method}
\alias{dmr_identification,data.frame-method}
\title{DMR identification from DMCs identified}
\usage{
dmr_identification(dmc_identification_object, ...)

\S4method{dmr_identification}{dmcResults}(dmc_identification_object, DMC_count = 2, ...)

\S4method{dmr_identification}{matrix}(dmc_identification_object, DMC_count = 2, ...)

\S4method{dmr_identification}{data.frame}(dmc_identification_object, DMC_count = 2, ...)
}
\arguments{
\item{dmc_identification_object}{a
\code{\link[betaHMM:dmcResults]{dmcResults}} object or the assay data
from the dmcResults.}

\item{...}{extra arguments}

\item{DMC_count}{The minimal number of consecutive CpGs in a DMR.}
}
\value{
An S4 object of class \code{\link[betaHMM:dmrResults]{dmrResults}}
where the CpG site information for each DMR is stored as a SimpleList
of assay data and the chromosomes analysed by the model is stored as
the metadata.
}
\description{
This is the primary user interface for the
\code{\link[betaHMM:dmr_identification]{dmr_identification}} function.
Generic S4 methods are implemented to identify the DMRs from the DMCs
identified in each chromosome. The supported classes are \code{data.frame}
and \code{\link[betaHMM:dmcResults]{dmcResults}} object. The output is an
S4 object of class \code{\link[betaHMM:dmrResults]{dmrResults}}.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

}
\seealso{
\code{\link{betaHMM}}
}
