% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHelpers.R
\name{getBF}
\alias{getBF}
\title{Calculate Bayes Factors}
\usage{
getBF(
  object,
  assay.postprob = "prob",
  assay.name = "bayes_factors",
  prior.params = list(a_pi = 2, b_pi = 300)
)
}
\arguments{
\item{object}{PhIPData object}

\item{assay.postprob}{string indicating the assay where posterior
probabilities are stored.}

\item{assay.name}{name indicating where the results should be stored in the
PhIPData object}

\item{prior.params}{prior parameters for the probability of enrichment 
(a_pi, b_pi)}
}
\value{
PhIPData object with the results stored in the location specified
by \code{assay.name}.
}
\description{
Calculate Bayes Factors
}
\examples{
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

## Calculate Bayes Factors
getBF(sim_data, "prob", "bayes_factor")

}
