% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAB.R
\name{.getABMLE}
\alias{.getABMLE}
\title{Wrapper function to derive MLE estimates of a, b from beads-only samples}
\usage{
.getABMLE(
  object,
  prop.offset = 1e-08,
  optim.method = "default",
  lower = 1,
  upper = Inf
)
}
\arguments{
\item{object}{a \code{\link[PhIPData]{PhIPData}} object}

\item{prop.offset}{offset to use when the proportion of reads is 0.}

\item{optim.method}{optimization method passed to \code{[stats::optim]}.}

\item{lower}{lower bound for the shape parameters.}

\item{upper}{upper bound for the shape parameters.}
}
\value{
a data frame of MLE estimates of a, b
}
\description{
Wrapper function to derive MLE estimates of a, b from beads-only samples
}
\seealso{
\code{[stats::optim]} for available optimization methods
}
