% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAB.R
\name{.getABEdgeR}
\alias{.getABEdgeR}
\title{Derive beta shape parameters using edgeR dispersion estimates}
\usage{
.getABEdgeR(
  object,
  threshold.cpm = 0,
  threshold.prevalence = 0,
  lower = 1,
  upper = Inf
)
}
\arguments{
\item{object}{a \code{\link[PhIPData]{PhIPData}} object.}

\item{threshold.cpm}{CPM threshold to be considered present in a sample.}

\item{threshold.prevalence}{proportion of beads-only samples that surpass
\code{threshold.cpm}.}

\item{lower}{minimum value of the beta shape parameters.}

\item{upper}{maximum value of the beta shape parameters.}
}
\value{
dataframe with rows corresponding to peptides and columns
corresponding to estimated shape parameters of the beta distribution.
}
\description{
Given a \code{\link[PhIPData]{PhIPData}} object, beads-only shape parameters
are estimated by first deriving the peptide-specific edgeR dispersion
estimate \eqn{\phi^{edgeR}}. \eqn{\phi^{edgeR}} corresponds to the squared
coefficient of variation for the proportion of reads pulled for a given
peptide. Using \eqn{\phi^{edgeR}} to derive an estimate of the variance for
the proportion of reads pulled by a single peptide, the mean and variance are
converted to shape parameters of a beta distribution.
}
\seealso{
[.edgeRBeads()] for estimating \eqn{\phi^{edgeR}}
}
