% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beadsRR.R
\name{.beadsRREdgeR}
\alias{.beadsRREdgeR}
\title{Function to run the beads-only round robin using edgeR}
\usage{
.beadsRREdgeR(
  object,
  threshold.cpm = 0,
  threshold.prevalence = 0,
  assay.names = c(logfc = "logfc", prob = "prob"),
  de.method = "exactTest",
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{object}{A PhIPData object of only beads-only samples.}

\item{threshold.cpm}{CPM threshold to be considered present in a sample}

\item{threshold.prevalence}{proportion of beads-only samples that surpass
\code{threshold.cpm}.}

\item{assay.names}{named vector specifying the assay names for the
log2(fold-change) and exact test p-values. If the vector is not names,
the first and second entries are used as defaults.}

\item{de.method}{character describing which edgeR test for differential
expression should be used. Must be one of `exactTest` or `glmQLFTest`.}

\item{BPPARAM}{\code{[BiocParallel::BiocParallelParam]} passed to
BiocParallel functions.}
}
\value{
vector of process IDs
}
\description{
Each sample is run in comparison to all other beads-only samples to
approximate the false positive rate of detecting enrichments.
}
