% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedbaser.R
\name{bb_example}
\alias{bb_example}
\title{Get the example BED file or BEDset with metadata}
\usage{
bb_example(bedbase, rec_type = c("bed", "bedset"))
}
\arguments{
\item{bedbase}{BEDbase() object}

\item{rec_type}{character(1) bed or bedset}
}
\value{
list() bed files or bedsets
}
\description{
Get the example BED file or BEDset available through
\href{https://api.bedbase.org}{bedhost}. Useful for an initial exploration
of bedbaser with an example BED file and BEDset in BEDbase.
}
\examples{
bedbase <- BEDbase()
ex_bed <- bb_example(bedbase, "bed")
str(ex_bed)
ex_bedset <- bb_example(bedbase, "bedset")
str(ex_bedset)
}
