% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configureEnvironment.R
\name{configureEnvironments}
\alias{configureEnvironments}
\title{Create environments with system installs}
\usage{
configureEnvironments(src)
}
\arguments{
\item{src}{String containing the local path to an R source file that defines the environments to be created.}
}
\value{
\code{NULL} is invisibly returned.
Conda environments are created in the R package installation directory if system installs are enabled.
Otherwise, no action is performed.
}
\description{
Create conda environments during installation of the R package, typically by calling this function in a package's \code{configure} file.
}
\details{
Sometimes, the lazy creation of new environments is not desirable.
For example, administrators of multi-user R instances would not want to create a separate environment in each user's cache.
Similarly, users of Docker images would not want to recreate the environment inside every new container. 

In these cases, an alternative is to use a \dQuote{system install}, where the environments are created during R package installation.
Each environment is directly created in the package's installation directory and is immediately available when \code{\link{createEnvironment}} is called.
Administrators can enable this mode by setting the \code{BIOCCMAKE_USE_SYSTEM_INSTALL} environment variable to 1.
Note that this setting takes effect during R package installation so should be set before (re-)installation of \pkg{basilisk.utils} and its dependencies.

Developers can support system installs by adding \code{configure(.win)} scripts to the root of their package.
These scripts should call \code{\link{configureEnvironments}} to trigger creation of the conda environments during R package installation.
Details of the environments to be created are taken from the \code{src} file, which should be executable as a standalone R file (i.e., it can be \code{\link{source}}d).
Each conda environment is defined as a list with a name ending in \code{_args}, where the list contains arguments to \code{\link{createEnvironment}}.

Packages that support system installs should also set \code{StagedInstall: no} in their \code{DESCRIPTION} files.
This ensures that the conda environments are created with the correct hard-coded paths in the package installation directory.
}
\examples{
# If we have a package with an 'R/environments.R' file,
# we could put the following in our 'configure' file.
\dontrun{configureEnvironments('R/environments.R')}

}
\author{
Aaron Lun
}
