% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processIlluminaSamplesheets_Functions.R
\docType{methods}
\name{createBasemasks}
\alias{createBasemasks}
\title{Function to create basemasks for basecalling from Illumina samplesheet (for bcl2Fastq versions >= 2.1.7).}
\usage{
createBasemasks(cleanedSampleSheet, param)
}
\arguments{
\item{cleanedSampleSheet}{Data.frame of cleaned samplesheet for Illumina basecalling using bcl2Fastq versions >= 2.1.7 (see vignette for more details)}

\item{param}{A BCL2FastQparams object}
}
\value{
A data.frame containing basecall masks per lane for reads and indexes as well as per lane complete basemasks.
}
\description{
Parses the Illumina sample sheet for versions >= 2.1.7 and creates basemasks.
}
\examples{

fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),verbose=FALSE)

cleanedSampleSheet <- validateBCLSheet(sampleSheet,param=bcl2fastqparams)
basemasks <- createBasemasks(cleanedSampleSheet,param=bcl2fastqparams)

}
\author{
Thomas Carroll and Marian Dore
}
