% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{posteriors}
\alias{posteriors}
\alias{posteriors,Bacon-method}
\title{Method to plot posterior distribution}
\usage{
posteriors(
  object,
  thetas = c("sigma.0", "p.0"),
  index = 1,
  alphas = c(0.95, 0.9, 0.75),
  xlab = "",
  ylab = "",
  ...
)

\S4method{posteriors}{Bacon}(
  object,
  thetas = c("sigma.0", "p.0"),
  index = 1,
  alphas = c(0.95, 0.9, 0.75),
  xlab = "",
  ylab = "",
  ...
)
}
\arguments{
\item{object}{'bacon'-object}

\item{thetas}{which thetas to plot}

\item{index}{if multiple sets of test-statsistics where provided}

\item{alphas}{significance level confidence ellipses}

\item{xlab}{optional xlab}

\item{ylab}{optional ylab}

\item{...}{additional plotting parameters}
}
\value{
plot of the Gibbs Sampler posterior probabilities
}
\description{
Method to plot posterior distribution
}
\examples{
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
##nbins = 100 to speed up the calculations
bc <- bacon(y, nbins=100)
posteriors(bc)
}
\seealso{
\code{\link{bacon}}
}
