% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_plot.R
\name{plot_design}
\alias{plot_design}
\title{Plot model}
\usage{
plot_design(object, coding = "code_control")
}
\arguments{
\item{object}{´SummarizedExperiment}

\item{coding}{string: codingfunname
\itemize{
    \item contr.treatment:          intercept = y0,     coefi = yi - y0
    \item contr.treatment.explicit: intercept = y0,     coefi = yi - y0
    \item code_control:             intercept = ymean,  coefi = yi - y0
    \item contr.diff:               intercept = y0,     coefi = yi - y(i-1)
    \item code_diff:                intercept = ymean,  coefi = yi - y(i-1)
    \item code_diff_forward:        intercept = ymean,  coefi = yi - y(i+)
    \item code_deviation:           intercept = ymean,  coefi = yi - ymean (drop last)
    \item code_deviation_first:     intercept = ymean,  coefi = yi - ymean (drop first)
    \item code_helmert:             intercept = ymean,  coefi = yi - mean(y0:(yi-1))
    \item code_helmert_forward:     intercept = ymean,  coefi = yi - mean(y(i+1):yp)
}}
}
\value{
ggplot
}
\description{
Plot model
}
\examples{
file <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
subgroups <- paste0(c('E00', 'E01', 'E02', 'E05', 'E15', 'E30', 'M00'), '_STD')
object <- read_maxquant_proteingroups(file, subgroups = subgroups)
object$subgroup \%<>\% substr(1,3)
plot_design(object)
}
