% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21_pca.R
\name{pca}
\alias{pca}
\alias{pls}
\alias{sma}
\alias{lda}
\alias{spls}
\alias{opls}
\title{PCA, SMA, LDA, PLS, SPLS, OPLS}
\usage{
pca(
  object,
  by = "sample_id",
  assay = assayNames(object)[1],
  ndim = 2,
  minvar = 0,
  center_samples = TRUE,
  verbose = TRUE,
  plot = FALSE,
  ...
)

pls(
  object,
  by = "subgroup",
  assay = assayNames(object)[1],
  ndim = 2,
  minvar = 0,
  verbose = FALSE,
  plot = FALSE,
  ...
)

sma(
  object,
  by = "sample_id",
  assay = assayNames(object)[1],
  ndim = 2,
  minvar = 0,
  verbose = TRUE,
  plot = FALSE,
  ...
)

lda(
  object,
  assay = assayNames(object)[1],
  by = "subgroup",
  ndim = 2,
  minvar = 0,
  verbose = TRUE,
  plot = FALSE,
  ...
)

spls(
  object,
  assay = assayNames(object)[1],
  by = "subgroup",
  ndim = 2,
  minvar = 0,
  plot = FALSE,
  ...
)

opls(
  object,
  by = "subgroup",
  assay = assayNames(object)[1],
  ndim = 2,
  minvar = 0,
  verbose = FALSE,
  plot = FALSE,
  ...
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{by}{svar or NULL}

\item{assay}{string}

\item{ndim}{number}

\item{minvar}{number}

\item{center_samples}{TRUE/FALSE: center samples prior to pca ?}

\item{verbose}{TRUE/FALSE: message ?}

\item{plot}{TRUE/FALSE: plot ?}

\item{...}{passed to biplot}
}
\value{
SummarizedExperiment
}
\description{
Perform a dimension reduction.
Store sample scores, feature loadings, and dimension variances.
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
 object <- read_metabolon(file)
 pca(object, plot = TRUE)    # Principal Component Analysis
 pls(object, plot = TRUE)    # Partial Least Squares
 lda(object, plot = TRUE)    # Linear Discriminant Analysis
 sma(object, plot = TRUE)    # Spectral Map Analysis
spls(object, plot = TRUE)    # Sparse PLS
# opls(object, plot = TRUE)  # OPLS # outcommented because it produces a file named FALSE
}
\author{
Aditya Bhagwat, Laure Cougnaud (LDA)
}
