% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_assertions.R
\name{is_fragpipe_tsv}
\alias{is_fragpipe_tsv}
\title{Is fragpipe file?}
\usage{
is_fragpipe_tsv(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{file}

\item{.xname}{name of x}
}
\description{
Is fragpipe file?
}
\examples{
file <- NULL;                                                                      is_fragpipe_tsv(file)
file <- 3;                                                                         is_fragpipe_tsv(file)
file <- 'blabla.tsv';                                                              is_fragpipe_tsv(file)
file <- download_data('dilution.report.tsv');                                      is_fragpipe_tsv(file)
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics'); is_fragpipe_tsv(file)
file <- system.file('extdata/billing19.phosphosites.txt', package = 'autonomics'); is_fragpipe_tsv(file)
file <- download_data('multiorganism.combined_protein.tsv');                       is_fragpipe_tsv(file)
}
