% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/28_awblinmod.R
\name{awblinmod}
\alias{awblinmod}
\alias{awblinmod_limma}
\alias{awblinmod_lm}
\alias{awblinmod_lme}
\alias{awblinmod_lmer}
\title{General Linear Modeling (across-within-between interface)}
\usage{
awblinmod(
  object,
  engine,
  modelvars,
  across = TRUE,
  within = if (length(modelvars) == 1) FALSE else TRUE,
  between = if (length(modelvars) == 1) FALSE else TRUE,
  coding = c("code_control", "code_diff"),
  drop = TRUE,
  verbose = TRUE,
  ...
)

awblinmod_limma(object, ...)

awblinmod_lm(object, ...)

awblinmod_lme(object, ...)

awblinmod_lmer(object, ...)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{engine}{'limma', 'lm', 'lme', or 'lmer'}

\item{modelvars}{svars}

\item{across}{TRUE/FALSE: fit across  model (additive)    ?}

\item{within}{TRUE/FALSE: fit within  model (nested)      ?}

\item{between}{TRUE/FALSE: fit between model (interaction) ?}

\item{coding}{character: codingfunname}

\item{drop}{TRUE or FALSE}

\item{verbose}{TRUE or FALSE}

\item{...}{passed to linmod}
}
\description{
General Linear Modeling (across-within-between interface)
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
svars(object)
awblinmod_limma(object, modelvars = c('Diabetes', 'Time'), block = 'Subject')
awblinmod_lme(  object, modelvars = c('Diabetes', 'Time'), block = 'Subject')
awblinmod_lmer( object, modelvars = c('Diabetes', 'Time'), block = 'Subject')
awblinmod_lm(   object, modelvars = c('Diabetes', 'Time'))
awblinmod(object, engine = 'limma', modelvars = 'Time')
awblinmod(object, engine = 'limma', modelvars = c('Diabetes', 'Time'))
}
