% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24_linmod.R
\name{write_xl}
\alias{write_xl}
\alias{write_ods}
\title{Write xl}
\usage{
write_xl(
  object,
  file,
  fitcoefs = autonomics::fitcoefs(object),
  assays = assayNames(object)[0],
  verbose = TRUE
)

write_ods(
  object,
  file,
  fitcoefs = autonomics::fitcoefs(object),
  assays = assayNames(object)[0],
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{file}{file}

\item{fitcoefs}{character vector}

\item{assays}{assayNames subset}

\item{verbose}{TRUE or FALSE}
}
\value{
filepath
}
\description{
Write xl
}
\examples{
# linmod
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    object \%<>\% linmod_limma(~Diabetes/Time)
    xlfile  <- file.path(tempdir(), 'linmod.atkin.metabolon.xlsx')
    odsfile <- file.path(tempdir(), 'linmod.atkin.metabolon.ods' )
    write_xl( object, xlfile)                                                               # linmod xlsx: fdt + stats
    write_xl( object, xlfile,  assays = SummarizedExperiment::assayNames(object)[1]  )      #              fdt + stats + assay
    write_xl( object, xlfile,  assays = SummarizedExperiment::assayNames(object)[1:2])      #              fdt + stats + assays
    write_ods(object, odsfile)                                                              #        ods:  fdt + stats
    write_ods(object, odsfile, assays = SummarizedExperiment::assayNames(object)[1]  )      #              fdt + stats + assay
    write_ods(object, odsfile, assays = SummarizedExperiment::assayNames(object)[1:2])      #              fdt + stats + assays

# awblinmod
    object <- read_metabolon(file)
    object \%<>\% awblinmod_limma(c('Diabetes', 'Time'), block = 'Subject')
    xlfile  <- file.path(tempdir(), 'awblinmod.atkin.metabolon.xlsx')
    odsfile <- file.path(tempdir(), 'awblinmod.atkin.metabolon.ods')
    write_xl( object, xlfile)                                                               # awblinmod xlsx: fdt + stats
    write_xl( object, xlfile,  assay = SummarizedExperiment::assayNames(object)[1]  )       #                 fdt + stats + assay
    write_xl( object, xlfile,  assay = SummarizedExperiment::assayNames(object)[1:2])       #                 fdt + stats + assays
    write_ods(object, odsfile)                                                              #           ods:  fdt + stats
    write_ods(object, odsfile, assay = SummarizedExperiment::assayNames(object)[1]  )       #                 fdt + stats + assay
    write_ods(object, odsfile, assay = SummarizedExperiment::assayNames(object)[1:2])       #                 fdt + stats + assays
}
