% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24_linmod.R
\name{guess_sep}
\alias{guess_sep}
\alias{guess_sep.numeric}
\alias{guess_sep.character}
\alias{guess_sep.factor}
\alias{guess_sep.SummarizedExperiment}
\title{Guess separator}
\usage{
guess_sep(x, ...)

\method{guess_sep}{numeric}(x, ...)

\method{guess_sep}{character}(x, separators = c(".", "_"), verbose = FALSE, ...)

\method{guess_sep}{factor}(x, ...)

\method{guess_sep}{SummarizedExperiment}(x, var = "sample_id", separators = c(".", "_"), verbose = FALSE, ...)
}
\arguments{
\item{x}{character vector or SummarizedExperiment}

\item{...}{used for proper S3 method dispatch}

\item{separators}{character vector: possible separators to look for}

\item{verbose}{TRUE or FALSE}

\item{var}{svar or fvar}
}
\value{
separator (string) or NULL (if no separator could be identified)
}
\description{
Guess separator
}
\examples{
# charactervector
   guess_sep(c('PERM_NON.R1[H/L]', 'PERM_NON.R2[H/L]'))
   guess_sep(c('WT_untreated_1', 'WT_untreated_2'))
   guess_sep(c('group1', 'group2.R1'))
# SummarizedExperiment
   file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
   object <- read_metabolon(file)
   guess_sep(object)
}
