% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_download.R
\docType{data}
\name{DATADIR}
\alias{DATADIR}
\alias{download_data}
\title{Download autonomics example data}
\format{
An object of class \code{character} of length 1.
}
\usage{
DATADIR

download_data(
  filename = NULL,
  localdir = file.path(DATADIR, split_extract_fixed(filename, ".", 1)),
  verbose = TRUE,
  force = FALSE
)
}
\arguments{
\item{filename}{file name
\tabular{rlr}{
        'atkin.somascan.adat'      \tab   \href{https://pubmed.ncbi.nlm.nih.gov/30525282/}{Halama, 2018}   \tab  effects of hypoglycemia     \cr
        'atkin.metabolon.xlsx'     \tab                                                                    \tab                              \cr
    'billing16.bam.zip'            \tab   \href{https://pubmed.ncbi.nlm.nih.gov/26857143/}{Billing, 2016}  \tab  stemcell comparison         \cr
    'billing16.rnacounts.txt'      \tab                                                                    \tab                              \cr
    'billing16.somascan.adat'      \tab                                                                    \tab                              \cr
    'billing16.proteingroups.txt'  \tab                                                                    \tab                              \cr
    'billing19.rnacounts.txt'      \tab   \href{https://pubmed.ncbi.nlm.nih.gov/31332097/}{Billing, 2016}  \tab  stemcell differentiation    \cr
    'billing19.proteingroups.txt'  \tab                                                                    \tab                              \cr
    'billing19.phosphosites.txt'   \tab                                                                    \tab                              \cr
    'ddglucose.proteingroups.txt'  \tab   Omics Module                                                     \tab  glycolysis inhibitor        \cr
     'fukuda20.proteingroups.txt'  \tab   \href{https://pubmed.ncbi.nlm.nih.gov/32648304/}{Fukuda, 2020}   \tab  zebrafish development       \cr 
     'halama18.metabolon.xlsx'     \tab   \href{https://pubmed.ncbi.nlm.nih.gov/29777783/}{Halama, 2018}   \tab  glutaminase inhibitor
}}

\item{localdir}{local dir to save file to}

\item{verbose}{TRUE / FALSE}

\item{force}{TRUE / FALSE}
}
\value{
local file path
}
\description{
Download autonomics example data
}
\examples{
# Show available datasets
    download_data()
    
# atkin 2018 - hypoglycemia - pubmed 30525282
    # download_data('atkin.somascan.adat')            # somascan  intensities
    # download_data('atkin.metabolon.xlsx')           # metabolon intensities

# billing16 - stemcell characterization - pubmed 26857143
    # download_data('billing16.proteingroups.txt')      # proteingroup ratios
    # download_data('billing16.somascan.adat')          # somascan  intensities
    # download_data('billing16.rnacounts.txt')          # rnaseq    counts
    # download_data('billing16.bam.zip')                # rnaseq    alignments

# billing19 - stemcell differentiation - pubmed 31332097
    # download_data('billing19.proteingroups.txt')    # proteingroup ratios
    # download_data('billing19.phosphosites.txt')     # phosphosite  ratios
    # download_data('billing19.rnacounts.txt')        # rnaseq       counts

# fukuda20 - heart regeneration - pubmed PXD016235
    # download_data('fukuda20.proteingroups.txt')       # proteingroup LFQ

# halama18 - glutaminase inhibition - pubmed 30525282
    # download_data('halama18.metabolon.xlsx')          # metabolon intensities
}
\keyword{datasets}
