% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualityControlEvidenceBasic.R
\name{artmsQualityControlEvidenceBasic}
\alias{artmsQualityControlEvidenceBasic}
\title{Quality Control analysis of the MaxQuant evidence file}
\usage{
artmsQualityControlEvidenceBasic(
  evidence_file,
  keys_file,
  prot_exp = c("AB", "PH", "UB", "AC", "APMS", "PTM:XXX:yy"),
  output_dir = "qc_basic",
  output_name = "qcBasic_evidence",
  isSILAC = FALSE,
  plotINTDIST = FALSE,
  plotREPRO = FALSE,
  plotCORMAT = TRUE,
  plotINTMISC = TRUE,
  plotPTMSTATS = TRUE,
  printPDF = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{evidence_file}{(char or data.frame) The evidence file path and name, or
data.frame}

\item{keys_file}{(char or data.frame) The keys file path and name or
data.frame}

\item{prot_exp}{(char) Proteomics experiment. 6 options available:
\itemize{
\item \code{APMS}: affinity purification mass spectrometry
\item \code{AB}: protein abundance
\item \code{PH}: protein phosphorylation
\item \code{UB}: protein ubiquitination (aka ubiquitylation)
\item \code{AC}: protein acetylation
\item \code{PTM:XXX:yy} : User defined PTM. Replace XXX with 1 or more 1-letter amino
acid codes on which to find modifications (all uppercase).  Replace yy with
modification name used within the evidence file (require lowercase characters).
Example for phosphorylation: \code{PTM:STY:ph} will find modifications on
aa S,T,Y with this example format \verb{_AAGGAPS(ph)PPPPVR_}. This means that
the user could select phosphorylation as \code{PH} or \code{PTM:STY:ph}
}}

\item{output_dir}{(char) Name for the folder to output the results plots.
Default is "qc_basic".}

\item{output_name}{(char) prefix output name (no extension).
Default: "qcBasic_evidence"}

\item{isSILAC}{if \code{TRUE} processes SILAC input files. Default is \code{FALSE}}

\item{plotINTDIST}{if \code{TRUE} plots both \emph{Box-dot plot}
and \emph{Jitter plot} of biological replicates based on MS (raw)
intensity values, otherwise \code{FALSE} (default)}

\item{plotREPRO}{if \code{TRUE} plots a correlation dotplot for all the
combinations of biological replicates of conditions, based on MS Intensity
values using features (peptide+charge). Otherwise \code{FALSE} (default)}

\item{plotCORMAT}{if \code{TRUE} (default) plots a
\itemize{
\item \emph{Correlation matrix} for all the biological replicates using
MS Intensity values,
\item \emph{Clustering matrix} of the MS Intensities
}}

\item{plotINTMISC}{if \code{TRUE} (default) plots several pages, including
bar plots of \emph{Total Sum of Intensities in BioReplicates},
\emph{Total Sum of Intensities in Conditions},
\emph{Total Peptide Counts in BioReplicates},
\emph{Total Peptide Counts in conditions} separated by categories:
\code{CON}: contaminants, \code{PROT} peptides, \code{REV} reversed sequences used by
MaxQuant to estimate the FDR; \emph{Box plots} of MS Intensity values per
biological replicates and conditions; \emph{bar plots} of total intensity
(excluding contaminants) by bioreplicates and conditions; Barplots of
\emph{total feature counts} by bioreplicates and conditions.}

\item{plotPTMSTATS}{IF \code{TRUE} (default) plots stats related to the
selected modification, including:
\emph{bar plot of peptide counts and intensities}, broken by \code{PTM/other}
categories; bar plots of \emph{total sum-up of MS intensity values} by
other/PTM categories.}

\item{printPDF}{If \code{TRUE} (default) prints out the pdfs. Warning: plot
objects are not returned due to the large number of them.}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
Quality control files and plots
}
\description{
Quality Control analysis of the MaxQuant evidence file
}
\examples{
artmsQualityControlEvidenceBasic(evidence_file = artms_data_ph_evidence,
                                 keys_file = artms_data_ph_keys, 
                                 prot_exp =  "PH", 
                                 isSILAC = FALSE,
                                 plotINTDIST = FALSE,
                                 plotREPRO = TRUE,
                                 plotCORMAT = FALSE,
                                 plotINTMISC = FALSE,
                                 plotPTMSTATS = FALSE,
                                 printPDF = FALSE,
                                 verbose = FALSE)

# But we recommend the following test:
# 1. Go to a working directory: 
# setwd("/path/to/your/working/directory/")
# 2. Run the following command to print out all the pdf files
# artmsQualityControlEvidenceBasic(evidence_file = artms_data_ph_evidence,
#                                  keys_file = artms_data_ph_keys, 
#                                  prot_exp =  "PH")
# 3. Check your working directory and you should find pdf files with 
# all the QC plots
}
\keyword{QC,}
\keyword{control,}
\keyword{evidence}
\keyword{quality,}
