% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolomics.R
\name{artmsConvertMetabolomics}
\alias{artmsConvertMetabolomics}
\title{Convert Markview Metabolomics file (alignment table) into
a artMS compatible format}
\usage{
artmsConvertMetabolomics(input_file, out_file, id_file = NULL, verbose = TRUE)
}
\arguments{
\item{input_file}{(char) Markview input file}

\item{out_file}{(char) Output file name}

\item{id_file}{(char) KEGG database}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
(text file) Outputs the converted output name
}
\description{
\code{artMS} enables the relative quantification of untargeted
polar metabolites using the alignment table generated by Markview.
MarkerView is an ABSciex software that supports the files
generated by Analyst software (\code{.wiff}) used to run our specific mass
spectrometer (ABSciex Triple TOF 5600+).
It also supports \code{.t2d} files generated by the
Applied Biosystems 4700/4800 MALDI-TOF.
MarkerView software is used to align mass spectrometry data from several
samples for comparison. Using the import feature in the software, \code{.wiff}
files (also \code{.t2d} MALDI-TOF files and tab-delimited \code{.txt} mass spectra data
in mass-intensity format) are loaded for retention time alignment.
Once the data files are selected, a series of windows will appear wherein
peak finding, alignment, and filtering options can be entered and selected.
These options include minimum spectral peak width, minimum retention time
peak width, retention time and mass tolerance, and the ability to filter
out peaks that do not appear in more than a user selected number of samples.

`artmsConvertMetabolomics`` processes the markview file to enable
QC analysis and relative quantification using the artMS functions
}
\examples{
# Testing that the arguments cannot be null
artmsConvertMetabolomics(input_file = NULL, 
                         out_file = NULL)
}
\keyword{convert}
\keyword{metabolomics,}
