% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqRegModes.R
\name{anota2seqRegModes}
\alias{anota2seqRegModes}
\title{Categorize genes into regulatory modes of gene expression (mRNA 
  abundance or changes in translational efficiency leading to altered 
  protein levels or buffering)}
\usage{
anota2seqRegModes(Anota2seqDataSet, mRNASelect = c(TRUE, TRUE))
}
\arguments{
\item{Anota2seqDataSet}{An Anota2seqDataSet containing the output of the 
anota2seqAnalyze and anota2seqSelSigGenes function for all analyzes.}

\item{mRNASelect}{A logical vector with length 2 that specifies how mRNA 
abundance genes will be identified. The first position of the vector 
indicates whether translated mRNA output (e.g. polysome-associated mRNA
or RPFs) should be taken into consideration when selecting mRNA 
abundance genes. The second position specifies whether the total mRNA 
output should be taken into consideration when selecting mRNA abundance
genes. (See details) Default is c(TRUE,TRUE), i.e. abundance 
identifiers need to pass thresholds for both changes in translated mRNA
and total mRNA.}
}
\value{
An Anota2seqDataSet. anota2seqRegModes adds a column specifying 
  the regulatory modes of each significant identifier to the dataframe in
  the 'selectedTranslatedmRNA', 'selectedTotalmRNA', 
  'selectedTranslation' and 'selectedBuffering' slots of the 
  Anota2seqDataSet. It also saves the output of anota2seqSelSigGenes for 
  identifier regulated by mRNA abundance in the mRNAAbundance slot of the
  object. See \code{\link{anota2seqGetOutput}} for a detailed
  description of these outputs.
}
\description{
Polysome or ribosome profiling allows the user to 
  distinguish between three regulatory modes of gene expression: changes 
  mRNA abundance or translational efficiency leading to altered protein 
  levels or buffering (see references). Following a complete analysis, 
  this function categorizes each identifier into one of these regulatory 
  patterns.
}
\details{
The regulatory modes are given a priority order. First, changes 
  in translational efficiency leading to altered protein levels is 
  considered such that if an identifier passed filtering for this 
  analysis it will be allocated to the translation group. Identifiers 
  that did not pass those thresholds are then considered for belonging to
  the mRNA abundance group. For this step, the user can decide to base 
  inclusion into the abundance group based on results from analysis of 
  translated mRNA (e.g. polysome-associated mRNA or RPF), total mRNA or 
  both (see below). Finally, the remaining identifiers can be assessed 
  for belonging to the translational buffering group. 
  
  An mRNA abundance identifier can be defined based on analysis of translated 
  mRNA (e.g. polysome associated mRNA or or RPF) and total mRNA (and also 
  assuring that fold changes follow the same direction). To perform such 
  analysis, mRNASelect should be set to c(TRUE, TRUE). Alternatively one can 
  identify mRNA abundance identifiers based on analysis of only 
  translated mRNA (e.g. polysome-associated mRNA or RPFs; mRNASelect = 
  c(TRUE, FALSE)) or only total mRNA (mRNASelect = c(FALSE, TRUE)).
}
\examples{
# Initialize the Anota2seqDataSet
data(anota2seq_data)
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)

# Perform analysis of changes in translational efficiency leading to altered
# protein levels or buffering; and differential expression of translated mRNA
# and total mRNA
Anota2seqDataSet <- anota2seqAnalyze(Anota2seqDataSet,
                                     analysis = c("translated mRNA","total mRNA",
                                                  "translation","buffering"))

# Select as significant genes of all analyzes, genes with a FDR < 0.15
Anota2seqDataSet <- anota2seqSelSigGenes(Anota2seqDataSet,
                                         maxPAdj = .15,
                                         analysis = c("translated mRNA",
                                                      "total mRNA",
                                                      "translation",
                                                      "buffering"),
                                         selContrast = 1)

# Determine which identifiers belong to which regulatory modes.
Anota2seqDataSet <- anota2seqRegModes(Anota2seqDataSet)

}
\references{
Oertlin C. et al. Genome-wide analysis of differential 
  translation and differential translational buffering using anota2seq, 
  bioRxiv, 2017.
}
\seealso{
\code{\link{anota2seqAnalyze}}, 
  \code{\link{anota2seqSelSigGenes}}, \code{\link{anota2seqRun}}
}
