% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAllGenerics.R, R/anota2seqMethods.R
\docType{methods}
\name{anota2seqGetNormalizedData}
\alias{anota2seqGetNormalizedData}
\alias{anota2seqGetNormalizedData,Anota2seqDataSet-method}
\title{Accessor for the 'normalizedDataP' and 'normalizedDataT' slots of an Anota2seqDataSet object.}
\usage{
anota2seqGetNormalizedData(object)

\S4method{anota2seqGetNormalizedData}{Anota2seqDataSet}(object)
}
\arguments{
\item{object}{A Anota2seqDataSet.}
}
\value{
A list of 2 elements named "dataP" and "dataT"
  containing the corresponding normalized data to be used for the analysis. Note 
  that dataT and dataP have the same sample order such that 
e.g. column 1 in dataP is the translated mRNA data for a sample, 
column 1 in dataT is the total mRNA data.
}
\description{
Retrieve the data that is used in the analysis (i.e. if raw RNAseq counts 
were supplied, this function retrieves the normalized counts used in the 
analysis).
}
\examples{
data(anota2seq_data)
# Initialize Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Get normalized dataP
normDataP <- anota2seqGetNormalizedData(Anota2seqDataSet)[["dataP"]]
head(normDataP)


}
\seealso{
\code{\link{Anota2seqDataSet-class}}
}
