% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAllGenerics.R, R/anota2seqMethods.R
\docType{methods}
\name{anota2seqGetCovariates}
\alias{anota2seqGetCovariates}
\alias{anota2seqGetCovariates,Anota2seqDataSet-method}
\title{Accessor for the 'phenoVec' and 'batchVec' slots of an Anota2seqDataSet 
object.}
\usage{
anota2seqGetCovariates(object)

\S4method{anota2seqGetCovariates}{Anota2seqDataSet}(object)
}
\arguments{
\item{object}{An Anota2seqDataSet.}
}
\value{
A list of 2 elements named "phenoVec" and "batchVec"
  containing the corresponding covariates to be used for the analysis.
}
\description{
Retrieve from an Anota2seqDataSet the covariate(s) to be used in the APV 
model i.e. the annotation of the samples according to their treatments and
batch (when provided).
}
\examples{
data(anota2seq_data)
# Initialize Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    batchVec = c(1, 2, 3, 4, 1, 2, 3, 4),
    dataType = "RNAseq",
    normalize = TRUE)
# Run analysis of differential translation
Anota2seqDataSet <- anota2seqAnalyze(Anota2seqDataSet, 
                                     analysis = "translation")
covariates <- anota2seqGetCovariates(Anota2seqDataSet)
covariates
# $phenoVec
# [1] "ctrl"      "ctrl"      "ctrl"      "ctrl"      "treatment" "treatment"
# [7] "treatment" "treatment"
# 
# $batchVec
# [1] "1" "2" "3" "4" "1" "2" "3" "4"
}
\seealso{
\code{\link{Anota2seqDataSet-class}}
}
