% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAnalyze.R
\name{anota2seqAnalyze}
\alias{anota2seqAnalyze}
\title{Analysis of translational activity}
\usage{
anota2seqAnalyze(Anota2seqDataSet, contrasts = NULL,
  correctionMethod = "BH", useProgBar = TRUE, fileStem = "ANOTA2SEQ",
  analysis = c("translation", "buffering", "translated mRNA", "total mRNA"))
}
\arguments{
\item{Anota2seqDataSet}{An object of class Anota2seqDataSet}

\item{contrasts}{If NULL (default), the contrasts will be created 
automatically and may not correspond to those of interest. It is 
therefore possible to use custom contrasts using this parameter. The 
input should be a matrix with row names corresponding to treatments 
(i.e. those in phenoVec or the treatment column of the 
SummarizedExperiment annotation) and columns corresponding to the 
different contrasts of interest (see Details section and examples for 
additional information on how to set up a custom contrast matrix).}

\item{correctionMethod}{Correction for multiple testing method. This 
parameter can be set to "Bonferroni", "Holm", "Hochberg", "SidakSS", 
"SidakSD", "BH", "BY", "ABH" or "TSBH" as implemented in the multtest 
package or "qvalue" as implemented in the qvalue package. Default is 
"BH".}

\item{useProgBar}{Should the progress bar be shown? Default is TRUE, show
progress bar.}

\item{fileStem}{Stem for output file name (see Value section). Default is 
"ANOTA2SEQ".}

\item{analysis}{Specification of which analysis should be performed. Can 
be set to "translated mRNA","total mRNA", "translation", "buffering" or
any combination of these. If set to translated mRNA or total mRNA, the 
function will perform differential expression analysis (based on 
default or supplied contrasts) for the specified mRNA source. If set to
"translation", analysis of changes in translational efficiency leading 
to altered protein levels will be performed. If set to "buffering", 
analysis of changes in translational efficiency leading to buffering 
will be performed. Default is c("translated mRNA", "total mRNA", 
"translation", "buffering") i.e. all analyzes are performed.}
}
\value{
An Anota2seqDataSet. anota2seqAnalyze saves its output data in 
  the 'translatedmRNA', 'totalmRNA', 'translation' and 'buffering' slots 
  of the Anota2seqDataSet output object when analysis is set to
  "translated mRNA", "total mRNA", "translation" and "buffering"
  respectively. This output contains statistics from the applied APV
  model and can be accessed using \code{\link{anota2seqGetOutput}} (See
  ?\code{\link{anota2seqGetOutput}} for a detailed description). Additionally, 
  \code{\link{anota2seqAnalyze}} saves fold changes and translational efficiency
  (TE) scores in the 'deltaData' slot of the Anota2seqDataSet object.
  (See ?\code{\link{anota2seqGetDeltaData}} for a detailed description of deltaData).
  
  \code{\link{anota2seqAnalyze}} creates a plot showing the fit of the inverse gamma 
  distribution used in RVM (i.e. a similar output as compared to that 
  from anota2seqPerformQC) for each contrast.
}
\description{
Analysis of treatment effects for translated mRNA 
  (polysome-associated mRNA or RPFs; i.e. the "P" samples in the 
  SummarizedExperiment annotation or the samples in the dataP matrix) or 
  total mRNA (i.e. the "T" samples in the SummarizedExperiment annotation
  or the samples in the dataT matrix); and/or identification of changes 
  in translational efficiency leading to altered protein levels or 
  buffering.
}
\details{
The function performs APV on two or more sample categories 
  according to default contrasts or contrasts supplied by the user. The 
  Random Variance Model (RVM) will be applied but the results without 
  RVM will also be available in the output.
  
  More details about setting a contrast matrix: By default (i.e. with 
  contrasts = NULL), the order of the sample classes which are used to 
  calculate differences between treatments will be in alphabetical order.
  To change the directionality of the contrasts (e.g. treatment b vs 
  treatment a instead of treatment a vs treatment b) or to generate a 
  custom set of contrasts when more than 2 treatments are included, a 
  contrast matrix can be supplied to the "contrasts" parameter described 
  above. The row names should be specified as indicated above. The 
  contrasts are coded by using e.g. -1 for group a, 0 for group b and 1 
  for group c to compare group a and c; -2 for group a, 1 for group b and
  1 for group c to compare group a to b & c. Each column of the contrast 
  matrix should sum to 0 and to analyze orthagonal contrasts the products
  of all pairwise rows should sum to 0. The results in the
  Anota2seqDataSet object will follow the order of the contrasts (i.e. 
  results for e.g. contrast 1 will correspond to the contrasts specified 
  in column 1 of the contrast matrix).
}
\examples{
data(anota2seq_data)
# Initialize Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Run analysis of changes in translational efficiency leading to 
# altered protein levels and differential expression analysis on 
# translated mRNA
\dontrun{
Anota2seqDataSet <- anota2seqAnalyze(
    Anota2seqDataSet,
    analysis = c("translation")) 
}
# Example to build a custom contrast matrix
# For the purpose of this example, we will use the first 6 samples of the 
# simulated data provided with the package together with the following "dummy"
# sample classes:
phenoVec <- c("a","a","b","b","c","c")
contrastsEx_ads <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100, 1:6],
    dataT = anota2seq_data_T[1:100, 1:6],
    phenoVec = phenoVec,
    dataType = "RNAseq",
    normalize = TRUE)

# Get the levels of the phenoVec, these will be ordered as in anota2seq
phenoLev <- levels(as.factor(phenoVec))
# Construct the matrix with appropriate nrow and ncol
myContrast <- matrix(nrow =length(phenoLev),ncol=length(phenoLev)-1)
# Set the phenoLev as rownames for your contrast matrix
rownames(myContrast) <- phenoLev
# Now indicate the contrasts you want to analyse as explained above
# Compare a to c
myContrast[,1] <- c(-1,0,1)
# Compare a to b& c
myContrast[,2] <- c(2,-1,-1)
myContrast
#   [,1] [,2]
# a   -1    2
# b    0   -1
# c    1   -1
# The custom contrast matrix can then be used as input of anota2seqAnalyze. 
contrastsEx_ads <- anota2seqAnalyze(contrastsEx_ads, 
                                    analysis = "translation",
                                    contrasts = myContrast)
                                    
}
\seealso{
\code{\link{anota2seqGetOutput}}, \code{\link{anota2seqGetDeltaData}}
}
