% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReticulateAnnData.R
\name{ReticulateAnnData}
\alias{ReticulateAnnData}
\title{ReticulateAnnData}
\value{
A \code{ReticulateAnnData} object
}
\description{
Implementation of an \code{AnnData} object that wraps a Python \strong{anndata}
\code{AnnData} object using \pkg{reticulate}. This allows direct interaction with
Python \code{AnnData} objects while maintaining the R interface. It is useful when
you already have a Python \code{AnnData} or to access functionality that has not
yet been implemented in \pkg{anndataR}.

See \link{AnnData-usage} for details on creating and using \code{AnnData} objects.
}
\seealso{
\link{AnnData-usage} for details on creating and using \code{AnnData} objects

Other AnnData classes: 
\code{\link{AbstractAnnData}},
\code{\link{AnnDataView}},
\code{\link{HDF5AnnData}},
\code{\link{InMemoryAnnData}}
}
\concept{AnnData classes}
\section{Super class}{
\code{\link[anndataR:AbstractAnnData]{anndataR::AbstractAnnData}} -> \code{ReticulateAnnData}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{X}}{See \link{AnnData-usage}}

\item{\code{layers}}{See \link{AnnData-usage}}

\item{\code{obs}}{See \link{AnnData-usage}}

\item{\code{var}}{See \link{AnnData-usage}}

\item{\code{obs_names}}{See \link{AnnData-usage}}

\item{\code{var_names}}{See \link{AnnData-usage}}

\item{\code{obsm}}{See \link{AnnData-usage}}

\item{\code{varm}}{See \link{AnnData-usage}}

\item{\code{obsp}}{See \link{AnnData-usage}}

\item{\code{varp}}{See \link{AnnData-usage}}

\item{\code{uns}}{See \link{AnnData-usage}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReticulateAnnData-new}{\code{ReticulateAnnData$new()}}
\item \href{#method-ReticulateAnnData-n_obs}{\code{ReticulateAnnData$n_obs()}}
\item \href{#method-ReticulateAnnData-n_vars}{\code{ReticulateAnnData$n_vars()}}
\item \href{#method-ReticulateAnnData-py_anndata}{\code{ReticulateAnnData$py_anndata()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="as_HDF5AnnData"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-as_HDF5AnnData'><code>anndataR::AbstractAnnData$as_HDF5AnnData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="as_InMemoryAnnData"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-as_InMemoryAnnData'><code>anndataR::AbstractAnnData$as_InMemoryAnnData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="as_ReticulateAnnData"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-as_ReticulateAnnData'><code>anndataR::AbstractAnnData$as_ReticulateAnnData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="as_Seurat"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-as_Seurat'><code>anndataR::AbstractAnnData$as_Seurat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="as_SingleCellExperiment"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-as_SingleCellExperiment'><code>anndataR::AbstractAnnData$as_SingleCellExperiment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="layers_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-layers_keys'><code>anndataR::AbstractAnnData$layers_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="obs_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-obs_keys'><code>anndataR::AbstractAnnData$obs_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="obsm_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-obsm_keys'><code>anndataR::AbstractAnnData$obsm_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="obsp_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-obsp_keys'><code>anndataR::AbstractAnnData$obsp_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="print"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-print'><code>anndataR::AbstractAnnData$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="shape"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-shape'><code>anndataR::AbstractAnnData$shape()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="uns_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-uns_keys'><code>anndataR::AbstractAnnData$uns_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="var_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-var_keys'><code>anndataR::AbstractAnnData$var_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="varm_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-varm_keys'><code>anndataR::AbstractAnnData$varm_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="varp_keys"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-varp_keys'><code>anndataR::AbstractAnnData$varp_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="anndataR" data-topic="AbstractAnnData" data-id="write_h5ad"><a href='../../anndataR/html/AbstractAnnData.html#method-AbstractAnnData-write_h5ad'><code>anndataR::AbstractAnnData$write_h5ad()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReticulateAnnData-new"></a>}}
\if{latex}{\out{\hypertarget{method-ReticulateAnnData-new}{}}}
\subsection{Method \code{new()}}{
\code{ReticulateAnnData} constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReticulateAnnData$new(
  py_anndata = NULL,
  X = NULL,
  obs = NULL,
  var = NULL,
  layers = NULL,
  obsm = NULL,
  varm = NULL,
  obsp = NULL,
  varp = NULL,
  uns = NULL,
  shape = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{py_anndata}}{A Python AnnData object created using reticulate, or
NULL to create a new empty Python AnnData object}

\item{\code{X}}{See the \code{X} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{obs}}{See the \code{obs} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{var}}{See the \code{var} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{layers}}{See the \code{layers} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{obsm}}{See the \code{obsm} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{varm}}{See the \code{varm} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{obsp}}{See the \code{obsp} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{varp}}{See the \code{varp} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{uns}}{See the \code{uns} slot in \link{AnnData-usage} (only used if py_anndata is NULL)}

\item{\code{shape}}{Shape tuple (e.g. \code{c(n_obs, n_vars)}). Can be provided if
both \code{X} or \code{obs} and \code{var} are not provided. (only used if py_anndata is NULL)}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The constructor creates a new ReticulateAnnData interface object that
wraps a Python AnnData object. If \code{py_anndata} is provided, it must be
a valid Python AnnData object. If NULL, a new Python AnnData object
will be created using the other provided arguments.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReticulateAnnData-n_obs"></a>}}
\if{latex}{\out{\hypertarget{method-ReticulateAnnData-n_obs}{}}}
\subsection{Method \code{n_obs()}}{
See the \code{n_obs} field in \link{AnnData-usage}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReticulateAnnData$n_obs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReticulateAnnData-n_vars"></a>}}
\if{latex}{\out{\hypertarget{method-ReticulateAnnData-n_vars}{}}}
\subsection{Method \code{n_vars()}}{
See the \code{n_vars} field in \link{AnnData-usage}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReticulateAnnData$n_vars()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReticulateAnnData-py_anndata"></a>}}
\if{latex}{\out{\hypertarget{method-ReticulateAnnData-py_anndata}{}}}
\subsection{Method \code{py_anndata()}}{
Get the underlying Python AnnData object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReticulateAnnData$py_anndata()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The Python AnnData object wrapped by this ReticulateAnnData
}
}
}
