% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_alpha_div_test.R
\name{do_alpha_div_test}
\alias{do_alpha_div_test}
\title{Alpha diversity statistical test}
\usage{
do_alpha_div_test(
  MAE,
  tax_level,
  condition,
  alpha_metric = c("inverse_simpson", "gini_simpson", "shannon", "fisher", "coverage",
    "unit"),
  alpha_stat = c("Wilcoxon rank sum test", "T-test", "Kruskal-Wallis")
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{condition}{Which condition to group samples}

\item{alpha_metric}{Which alpha diversity metric to use}

\item{alpha_stat}{Which stat test to use}
}
\value{
A dataframe
}
\description{
Alpha diversity statistical test
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
p <- do_alpha_div_test(toy_data,
  tax_level = "genus",
  condition = "DISEASE",
  alpha_metric = "shannon",
  alpha_stat = "Wilcoxon rank sum test"
)
p

}
