% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{pairwiseApply}
\alias{pairwiseApply}
\alias{pairwiseApply-generic}
\title{Apply a function on each pair of features}
\usage{
pairwiseApply(X, ...)
}
\arguments{
\item{X}{input object}

\item{...}{additional arguments}
}
\value{
a list containing the output of applying the function to each feature pair.
See \code{?base::mapply()}
}
\description{
Apply a function on each pair of features
}
\examples{
web <- randomWeb(10)

# For each feature pair, was the value for x higher than the value for y?
pairwise_gt <- pairwiseApply(
    X = web,
    FUN = function(x, y) x > y,
    MoreArgs = NULL, SIMPLIFY = FALSE, USE.NAMES = TRUE
)

head(pairwise_gt)

# Run cor.test() on each pair of features
pairwise_cor <- pairwiseApply(
    X = web,
    FUN = function(x, y) cor.test(x, y),
    MoreArgs = NULL, SIMPLIFY = FALSE, USE.NAMES = TRUE
)

pairwise_cor[1]

}
